/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors.modbustcpipv1;

import de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusMap;
import de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusVarItem;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.net.ModbusTCPListener;
import net.wimpi.modbus.procimg.ProcessImage;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.procimg.SimpleProcessImage;
import net.wimpi.modbus.procimg.SimpleRegister;

public class TestServer {
    private ModbusTCPListener mListener = null;
    private InetAddress mHost;
    private int mPort;
    private String serverStructure;
    private ModbusMap map;

    public TestServer(boolean defaultPort) {
        this.mPort = !defaultPort ? NetUtils.getEphemeralPort() : 502;
        this.serverStructure = this.createServerStructure();
        this.map = (ModbusMap)JsonUtils.fromJson((Object)this.serverStructure, ModbusMap.class);
        if (this.map == null) {
            System.out.println("TestServer -> No SERVER_STRUCTURE found");
        }
        SimpleProcessImage spi = null;
        spi = new SimpleProcessImage();
        int registerCount = this.getRegisterCount();
        for (int i = 0; i < registerCount; ++i) {
            spi.addRegister((Register)new SimpleRegister(0));
        }
        ModbusCoupler.getReference().setProcessImage((ProcessImage)spi);
        ModbusCoupler.getReference().setMaster(false);
        ModbusCoupler.getReference().setUnitID(1);
        this.mListener = new ModbusTCPListener(3);
        this.mListener.setPort(this.mPort);
        try {
            this.mHost = InetAddress.getLocalHost();
            this.mListener.setAddress(this.mHost);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.map = new ModbusMap();
    }

    public void start() {
        if (this.mListener != null) {
            this.mListener.start();
        }
    }

    public void stop() {
        if (this.mListener != null) {
            this.mListener.stop();
        }
    }

    public String getHost() {
        return this.mHost.getHostAddress();
    }

    public int getPort() {
        return this.mPort;
    }

    public ModbusMap getMap() {
        return this.map;
    }

    public int getRegisterCount() {
        int maxOffset = 0;
        for (Map.Entry entry : this.map.entrySet()) {
            ModbusVarItem value = (ModbusVarItem)entry.getValue();
            if (value.getOffset() <= maxOffset) continue;
            maxOffset = value.getOffset();
        }
        System.out.println("ServerRegisterCount: " + (maxOffset += 4));
        return maxOffset;
    }

    private String createServerStructure() {
        Object serverSettings = "{";
        serverSettings = (String)serverSettings + "\"Short\" : {\"offset\" : 0, \"type\" : \"short\"},";
        serverSettings = (String)serverSettings + "\"Integer\" : {\"offset\" : 1, \"type\" : \"integer\"},";
        serverSettings = (String)serverSettings + "\"Float\" : {\"offset\" : 3, \"type\" : \"float\"},";
        serverSettings = (String)serverSettings + "\"Long\" : {\"offset\" : 5, \"type\" : \"long\"},";
        serverSettings = (String)serverSettings + "\"Double\" : {\"offset\" : 9, \"type\" : \"double\"}";
        serverSettings = (String)serverSettings + "}";
        return serverSettings;
    }

    public String getServerStructure() {
        return this.serverStructure;
    }
}

