/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ConditionTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.TwoStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.AcknowledgeableConditionType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class AcknowledgeableConditionTypeNode
extends ConditionTypeNode
implements AcknowledgeableConditionType {
    public AcknowledgeableConditionTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public LocalizedText getEnabledState() throws UaException {
        TwoStateVariableTypeNode node = this.getEnabledStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setEnabledState(LocalizedText enabledState) throws UaException {
        TwoStateVariableTypeNode node = this.getEnabledStateNode();
        node.setValue(new Variant((Object)enabledState));
    }

    @Override
    public LocalizedText readEnabledState() throws UaException {
        try {
            return this.readEnabledStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEnabledState(LocalizedText enabledState) throws UaException {
        try {
            this.writeEnabledStateAsync(enabledState).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readEnabledStateAsync() {
        return ((CompletableFuture)this.getEnabledStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEnabledStateAsync(LocalizedText enabledState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)enabledState));
        return this.getEnabledStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getEnabledStateNode() throws UaException {
        try {
            return this.getEnabledStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends TwoStateVariableTypeNode> getEnabledStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EnabledState", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getAckedState() throws UaException {
        TwoStateVariableTypeNode node = this.getAckedStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setAckedState(LocalizedText ackedState) throws UaException {
        TwoStateVariableTypeNode node = this.getAckedStateNode();
        node.setValue(new Variant((Object)ackedState));
    }

    @Override
    public LocalizedText readAckedState() throws UaException {
        try {
            return this.readAckedStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAckedState(LocalizedText ackedState) throws UaException {
        try {
            this.writeAckedStateAsync(ackedState).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readAckedStateAsync() {
        return ((CompletableFuture)this.getAckedStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAckedStateAsync(LocalizedText ackedState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)ackedState));
        return this.getAckedStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getAckedStateNode() throws UaException {
        try {
            return this.getAckedStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getAckedStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AckedState", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getConfirmedState() throws UaException {
        TwoStateVariableTypeNode node = this.getConfirmedStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setConfirmedState(LocalizedText confirmedState) throws UaException {
        TwoStateVariableTypeNode node = this.getConfirmedStateNode();
        node.setValue(new Variant((Object)confirmedState));
    }

    @Override
    public LocalizedText readConfirmedState() throws UaException {
        try {
            return this.readConfirmedStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeConfirmedState(LocalizedText confirmedState) throws UaException {
        try {
            this.writeConfirmedStateAsync(confirmedState).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readConfirmedStateAsync() {
        return ((CompletableFuture)this.getConfirmedStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConfirmedStateAsync(LocalizedText confirmedState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)confirmedState));
        return this.getConfirmedStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getConfirmedStateNode() throws UaException {
        try {
            return this.getConfirmedStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getConfirmedStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConfirmedState", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }
}

