/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.PerformUpdateType;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;

public class UpdateStructureDataDetails
extends HistoryUpdateDetails
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11295");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11300");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11296");
    private final PerformUpdateType performInsertReplace;
    private final DataValue[] updateValues;

    public UpdateStructureDataDetails(NodeId nodeId, PerformUpdateType performInsertReplace, DataValue[] updateValues) {
        super(nodeId);
        this.performInsertReplace = performInsertReplace;
        this.updateValues = updateValues;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public PerformUpdateType getPerformInsertReplace() {
        return this.performInsertReplace;
    }

    public DataValue[] getUpdateValues() {
        return this.updateValues;
    }

    protected UpdateStructureDataDetails(UpdateStructureDataDetailsBuilder<?, ?> b) {
        super((HistoryUpdateDetails.HistoryUpdateDetailsBuilder<?, ?>)b);
        this.performInsertReplace = ((UpdateStructureDataDetailsBuilder)b).performInsertReplace;
        this.updateValues = ((UpdateStructureDataDetailsBuilder)b).updateValues;
    }

    public static UpdateStructureDataDetailsBuilder<?, ?> builder() {
        return new UpdateStructureDataDetailsBuilderImpl();
    }

    public UpdateStructureDataDetailsBuilder<?, ?> toBuilder() {
        return new UpdateStructureDataDetailsBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateStructureDataDetails)) {
            return false;
        }
        UpdateStructureDataDetails other = (UpdateStructureDataDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PerformUpdateType this$performInsertReplace = this.getPerformInsertReplace();
        PerformUpdateType other$performInsertReplace = other.getPerformInsertReplace();
        if (this$performInsertReplace == null ? other$performInsertReplace != null : !this$performInsertReplace.equals(other$performInsertReplace)) {
            return false;
        }
        return Arrays.deepEquals(this.getUpdateValues(), other.getUpdateValues());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UpdateStructureDataDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        PerformUpdateType $performInsertReplace = this.getPerformInsertReplace();
        result = result * 59 + ($performInsertReplace == null ? 43 : $performInsertReplace.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getUpdateValues());
        return result;
    }

    @Override
    public String toString() {
        return "UpdateStructureDataDetails(performInsertReplace=" + this.getPerformInsertReplace() + ", updateValues=" + Arrays.deepToString(this.getUpdateValues()) + ")";
    }

    private static final class UpdateStructureDataDetailsBuilderImpl
    extends UpdateStructureDataDetailsBuilder<UpdateStructureDataDetails, UpdateStructureDataDetailsBuilderImpl> {
        private UpdateStructureDataDetailsBuilderImpl() {
        }

        @Override
        protected UpdateStructureDataDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public UpdateStructureDataDetails build() {
            return new UpdateStructureDataDetails(this);
        }
    }

    public static abstract class UpdateStructureDataDetailsBuilder<C extends UpdateStructureDataDetails, B extends UpdateStructureDataDetailsBuilder<C, B>>
    extends HistoryUpdateDetails.HistoryUpdateDetailsBuilder<C, B> {
        private PerformUpdateType performInsertReplace;
        private DataValue[] updateValues;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            UpdateStructureDataDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(UpdateStructureDataDetails instance, UpdateStructureDataDetailsBuilder<?, ?> b) {
            b.performInsertReplace(instance.performInsertReplace);
            b.updateValues(instance.updateValues);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B performInsertReplace(PerformUpdateType performInsertReplace) {
            this.performInsertReplace = performInsertReplace;
            return (B)this.self();
        }

        public B updateValues(DataValue[] updateValues) {
            this.updateValues = updateValues;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "UpdateStructureDataDetails.UpdateStructureDataDetailsBuilder(super=" + super.toString() + ", performInsertReplace=" + this.performInsertReplace + ", updateValues=" + Arrays.deepToString(this.updateValues) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<UpdateStructureDataDetails> {
        @Override
        public Class<UpdateStructureDataDetails> getType() {
            return UpdateStructureDataDetails.class;
        }

        @Override
        public UpdateStructureDataDetails decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            PerformUpdateType performInsertReplace = decoder.readEnum("PerformInsertReplace", PerformUpdateType.class);
            DataValue[] updateValues = decoder.readDataValueArray("UpdateValues");
            return new UpdateStructureDataDetails(nodeId, performInsertReplace, updateValues);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, UpdateStructureDataDetails value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeEnum("PerformInsertReplace", value.getPerformInsertReplace());
            encoder.writeDataValueArray("UpdateValues", value.getUpdateValues());
        }
    }
}

