/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaBinaryDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultBinaryEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;

public class OpcUaBinaryDataTypeDictionary
implements DataTypeDictionary<OpcUaBinaryDataTypeCodec<?>> {
    private final String namespaceUri;
    private final Map<String, OpcUaBinaryDataTypeCodec<?>> codecsByDescription;
    private final Map<NodeId, OpcUaBinaryDataTypeCodec<?>> codecsByEncodingId;
    private final Map<NodeId, OpcUaBinaryDataTypeCodec<?>> codecsByDataTypeId;

    public OpcUaBinaryDataTypeDictionary(String namespaceUri) {
        this.namespaceUri = namespaceUri;
        this.codecsByDescription = Maps.newConcurrentMap();
        this.codecsByEncodingId = Maps.newConcurrentMap();
        this.codecsByDataTypeId = Maps.newConcurrentMap();
    }

    public OpcUaBinaryDataTypeDictionary(String namespaceUri, Map<String, OpcUaBinaryDataTypeCodec<?>> byDescription, Map<NodeId, OpcUaBinaryDataTypeCodec<?>> byEncodingId, Map<NodeId, OpcUaBinaryDataTypeCodec<?>> byDataTypeId) {
        this.namespaceUri = namespaceUri;
        this.codecsByDescription = Maps.newConcurrentMap();
        this.codecsByDescription.putAll(byDescription);
        this.codecsByEncodingId = Maps.newConcurrentMap();
        this.codecsByEncodingId.putAll(byEncodingId);
        this.codecsByDataTypeId = Maps.newConcurrentMap();
        this.codecsByDataTypeId.putAll(byDataTypeId);
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public QualifiedName getEncodingName() {
        return OpcUaDefaultBinaryEncoding.ENCODING_NAME;
    }

    @Override
    public OpcUaBinaryDataTypeCodec<?> getCodec(String description) {
        return this.codecsByDescription.get(description);
    }

    @Override
    public OpcUaBinaryDataTypeCodec<?> getCodec(NodeId dataTypeId) {
        return this.codecsByDataTypeId.get(dataTypeId);
    }

    @Override
    public void registerEnumCodec(OpcUaBinaryDataTypeCodec<?> codec, String description) {
        this.codecsByDescription.put(description, codec);
    }

    @Override
    public void registerEnumCodec(OpcUaBinaryDataTypeCodec<?> codec, String description, NodeId dataTypeId) {
        this.codecsByDescription.put(description, codec);
        this.codecsByDataTypeId.put(dataTypeId, codec);
    }

    @Override
    public void registerStructCodec(OpcUaBinaryDataTypeCodec<?> codec, String description, NodeId dataTypeId, NodeId encodingId) {
        this.codecsByDescription.put(description, codec);
        this.codecsByDataTypeId.put(dataTypeId, codec);
        this.codecsByEncodingId.put(encodingId, codec);
    }

    @Override
    public Map<String, OpcUaBinaryDataTypeCodec<?>> getCodecsByDescription() {
        return this.codecsByDescription;
    }

    @Override
    public Map<NodeId, OpcUaBinaryDataTypeCodec<?>> getCodecsByEncodingId() {
        return this.codecsByEncodingId;
    }

    @Override
    public Map<NodeId, OpcUaBinaryDataTypeCodec<?>> getCodecsByDataTypeId() {
        return this.codecsByDataTypeId;
    }
}

