/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.subscriptions;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.subscriptions.BatchModifyMonitoredItems;
import org.eclipse.milo.opcua.sdk.client.subscriptions.ManagedItem;
import org.eclipse.milo.opcua.sdk.client.subscriptions.ManagedSubscription;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaMonitoredItem;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class ManagedDataItem
extends ManagedItem {
    private final CopyOnWriteArrayList<DataValueListener> dataValueListeners = new CopyOnWriteArrayList();
    private UaMonitoredItem.ValueConsumer valueConsumer = null;

    ManagedDataItem(OpcUaClient client, ManagedSubscription subscription, OpcUaMonitoredItem item) {
        super(client, subscription, item);
    }

    @Override
    public CompletableFuture<Unit> deleteAsync() {
        return this.subscription.deleteDataItemAsync(this);
    }

    public double getSamplingInterval() {
        return this.monitoredItem.getRevisedSamplingInterval();
    }

    public double setSamplingInterval(double samplingInterval) throws UaException {
        try {
            return this.setSamplingIntervalAsync(samplingInterval).get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<Double> setSamplingIntervalAsync(double samplingInterval) {
        MonitoringParameters parameters = new MonitoringParameters(this.monitoredItem.getClientHandle(), Double.valueOf(samplingInterval), this.monitoredItem.getMonitoringFilter(), this.monitoredItem.getRevisedQueueSize(), Boolean.valueOf(this.monitoredItem.getDiscardOldest()));
        MonitoredItemModifyRequest modifyRequest = new MonitoredItemModifyRequest(this.monitoredItem.getMonitoredItemId(), parameters);
        CompletableFuture<List<StatusCode>> future = this.subscription.getSubscription().modifyMonitoredItems(this.subscription.getDefaultTimestamps(), Collections.singletonList(modifyRequest));
        return ((CompletableFuture)future.thenApply(statusCodes -> (StatusCode)statusCodes.get(0))).thenCompose(statusCode -> {
            if (statusCode.isGood()) {
                return CompletableFuture.completedFuture(this.monitoredItem.getRevisedSamplingInterval());
            }
            return FutureUtils.failedUaFuture((StatusCode)statusCode);
        });
    }

    public CompletableFuture<Double> setSamplingIntervalAsync(double samplingInterval, BatchModifyMonitoredItems batch) {
        CompletableFuture<BatchModifyMonitoredItems.ModifyMonitoredItemResult> future = batch.add(this.getMonitoredItem(), b -> b.setSamplingInterval(samplingInterval));
        return future.thenCompose(result -> {
            if (result.isServiceResultGood()) {
                Optional<CompletableFuture> opt = result.operationResult().map(s -> {
                    if (s.isGood()) {
                        return CompletableFuture.completedFuture(this.getSamplingInterval());
                    }
                    return FutureUtils.failedUaFuture((StatusCode)s);
                });
                return opt.orElse(FutureUtils.failedUaFuture((StatusCode)new StatusCode(0x80020000L)));
            }
            return FutureUtils.failedUaFuture((StatusCode)result.serviceResult());
        });
    }

    public synchronized DataValueListener addDataValueListener(Consumer<DataValue> consumer) {
        DataValueListener dataValueListener = (item, value) -> consumer.accept(value);
        this.addDataValueListener(dataValueListener);
        return dataValueListener;
    }

    public synchronized void addDataValueListener(DataValueListener dataValueListener) {
        this.dataValueListeners.add(dataValueListener);
        if (this.valueConsumer == null) {
            this.valueConsumer = new ManagedValueConsumer();
            this.monitoredItem.setValueConsumer(this.valueConsumer);
        }
    }

    public synchronized boolean removeDataValueListener(DataValueListener dataValueListener) {
        boolean removed = this.dataValueListeners.remove(dataValueListener);
        if (this.dataValueListeners.isEmpty()) {
            this.monitoredItem.setValueConsumer((UaMonitoredItem.ValueConsumer)null);
            this.valueConsumer = null;
        }
        return removed;
    }

    private class ManagedValueConsumer
    implements UaMonitoredItem.ValueConsumer {
        private ManagedValueConsumer() {
        }

        @Override
        public void onValueArrived(UaMonitoredItem item, DataValue value) {
            ManagedDataItem.this.dataValueListeners.forEach(dataValueListener -> dataValueListener.onDataValueReceived(ManagedDataItem.this, value));
        }
    }

    public static interface DataValueListener {
        public void onDataValueReceived(ManagedDataItem var1, DataValue var2);
    }
}

