/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestUtil {
    private static final Logger logger = LoggerFactory.getLogger(ManifestUtil.class);
    private static final Map<String, String> attributes = ManifestUtil.load();

    public static Optional<String> read(String name) {
        return Optional.ofNullable(attributes.get(name));
    }

    public static boolean exists(String name) {
        return attributes.containsKey(name);
    }

    private static Map<String, String> load() {
        ConcurrentMap attributes = Maps.newConcurrentMap();
        for (URI uri : ManifestUtil.uris()) {
            try {
                attributes.putAll(ManifestUtil.load(uri.toURL()));
            }
            catch (Throwable t) {
                logger.error("load(): '{}' failed", (Object)uri, (Object)t);
            }
        }
        return attributes;
    }

    private static Map<String, String> load(URL url) throws IOException {
        return ManifestUtil.load(url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> load(InputStream stream) {
        ConcurrentMap props = Maps.newConcurrentMap();
        try {
            Manifest manifest = new Manifest(stream);
            Attributes attributes = manifest.getMainAttributes();
            for (Object key : attributes.keySet()) {
                String value = attributes.getValue((Attributes.Name)key);
                props.put(key.toString(), value);
            }
        }
        catch (Throwable t) {
            logger.error("#load(): failed", t);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException manifest) {}
        }
        return props;
    }

    private static Set<URI> uris() {
        try {
            Enumeration<URL> resources = ManifestUtil.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            HashSet<URI> uris = new HashSet<URI>();
            while (resources.hasMoreElements()) {
                uris.add(resources.nextElement().toURI());
            }
            return uris;
        }
        catch (Throwable t) {
            logger.error("uris() failed", t);
            return Collections.emptySet();
        }
    }
}

