/**
 * ******************************************************************************
 * Copyright (c) {2022} The original author or authors
 *
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the Eclipse Public License 2.0 which is available 
 * at http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: Apache-2.0 OR EPL-2.0
 ********************************************************************************/

package de.iip_ecosphere.platform.connectors.events;

/**
 * Generic marker interface for connector queries representing a specification what to trigger/ingest. 
 * Capabilities depend on the connector and implementations may be connector specific.
 * 
 * @author Holger Eichelberger, SSE
 */
public interface ConnectorTriggerQuery {
    
    /**
     * Delay for multiple-data streamed result.
     * 
     * @return delay between two result data points in ms, none/existing timing if not positive
     */
    public default int delay() {
        return 0;
    }

}
