/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public interface ConnectorExtensionDescriptor {
    public boolean handlesConnectorForExtension(String var1);

    public <T> T getConnectorExtension(Class<T> var1, Supplier<T> var2);

    public static <T> T getExtension(Connector<?, ?, ?, ?> connector, Class<T> cls, Supplier<T> dflt) {
        return ConnectorExtensionDescriptor.getExtension(connector.getInstanceIdentification(), cls, dflt);
    }

    public static <T> T getExtension(String id, Class<T> cls, Supplier<T> dflt) {
        T result;
        ServiceLoader<ConnectorExtensionDescriptor> loader = ServiceLoader.load(ConnectorExtensionDescriptor.class);
        Optional<ConnectorExtensionDescriptor> desc = ServiceLoaderUtils.stream(loader).filter(d -> d.handlesConnectorForExtension(id)).findFirst();
        if (desc.isPresent()) {
            result = desc.get().getConnectorExtension(cls, dflt);
        } else {
            result = dflt.get();
            LoggerFactory.getLogger(ConnectorExtensionDescriptor.class).warn("No connector extension found for '{}'. Loaded via JSL?", cls);
        }
        return result;
    }

    public static <T, V> T getConnectorExtensionValue(Class<T> cls, Supplier<V> val, Supplier<T> dflt) {
        V v = val.get();
        T result = cls == v.getClass() ? cls.cast(v) : dflt.get();
        return result;
    }

    public static abstract class DefaultConnectorExtension<V>
    implements ConnectorExtensionDescriptor {
        private String id;
        private Supplier<V> valSupplier;

        public DefaultConnectorExtension(String id, Supplier<V> valSupplier) {
            this.id = id;
            this.valSupplier = valSupplier;
        }

        @Override
        public boolean handlesConnectorForExtension(String identification) {
            return this.id.equals(identification);
        }

        @Override
        public <T> T getConnectorExtension(Class<T> cls, Supplier<T> dflt) {
            return ConnectorExtensionDescriptor.getConnectorExtensionValue(cls, this.valSupplier, dflt);
        }
    }
}

