/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.model;

import de.iip_ecosphere.platform.connectors.model.AbstractModelAccess;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTypeMappingModelAccess
extends AbstractModelAccess {
    private Map<Class<?>, Setter> setters = new HashMap();

    protected AbstractTypeMappingModelAccess(AbstractModelAccess.NotificationChangedListener notificationChangedListener) {
        super(notificationChangedListener);
        this.setters.put(Integer.class, (n, v) -> this.setInt(n, (Integer)v));
        this.setters.put(Double.class, (n, v) -> this.setDouble(n, (Double)v));
        this.setters.put(Float.class, (n, v) -> this.setFloat(n, ((Float)v).floatValue()));
        this.setters.put(Long.class, (n, v) -> this.setLong(n, (Long)v));
        this.setters.put(Byte.class, (n, v) -> this.setByte(n, (Byte)v));
        this.setters.put(Short.class, (n, v) -> this.setShort(n, (Short)v));
        this.setters.put(Boolean.class, (n, v) -> this.setBoolean(n, (Boolean)v));
        this.setters.put(String.class, (n, v) -> this.setString(n, (String)v));
    }

    @Override
    public void set(String qName, Object value) throws IOException {
        Setter setter = this.setters.get(value.getClass());
        if (null != setter) {
            setter.set(qName, value);
        } else {
            this.setString(qName, value.toString());
        }
    }

    @Override
    public abstract void setInt(String var1, int var2) throws IOException;

    @Override
    public abstract void setLong(String var1, long var2) throws IOException;

    @Override
    public abstract void setByte(String var1, byte var2) throws IOException;

    @Override
    public abstract void setShort(String var1, short var2) throws IOException;

    @Override
    public abstract void setBoolean(String var1, boolean var2) throws IOException;

    @Override
    public abstract void setDouble(String var1, double var2) throws IOException;

    @Override
    public abstract void setFloat(String var1, float var2) throws IOException;

    @Override
    public abstract void setString(String var1, String var2) throws IOException;

    private static interface Setter {
        public void set(String var1, Object var2) throws IOException;
    }
}

