/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.AbstractConnector;
import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorExtensionDescriptor;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.types.AbstractProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.support.jsl.ExcludeFirst;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class ConnectorExtensionDescriptorTest {
    private static final String ID = "abba";
    private static final String VALUE = "xyz";

    @Test
    public void testExtension() throws IOException {
        MyConnector conn = new MyConnector();
        conn.setInstanceIdentification(ID);
        Assert.assertNull((Object)conn.extensionValue);
        conn.connect(ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)"localhost", (int)0).build());
        Assert.assertEquals((Object)VALUE, (Object)conn.extensionValue);
        conn.disconnect();
    }

    private static class MyConnector
    extends AbstractConnector<Object, Object, Object, Object> {
        private String extensionValue;

        private MyConnector() {
            super(new ProtocolAdapter[]{new AbstractProtocolAdapter<Object, Object, Object, Object>(){

                public Object adaptInput(Object data) throws IOException {
                    return data;
                }

                public Object adaptOutput(String channel, Object data) throws IOException {
                    return data;
                }

                public Class<? extends Object> getProtocolInputType() {
                    return Object.class;
                }

                public Class<? extends Object> getConnectorInputType() {
                    return Object.class;
                }

                public Class<? extends Object> getProtocolOutputType() {
                    return Object.class;
                }

                public Class<? extends Object> getConnectorOutputType() {
                    return Object.class;
                }

                public void initializeModelAccess() throws IOException {
                }
            }});
        }

        public String supportedEncryption() {
            return null;
        }

        public String enabledEncryption() {
            return null;
        }

        public String getName() {
            return "MyConnector";
        }

        protected void connectImpl(ConnectorParameter params) throws IOException {
            this.extensionValue = (String)ConnectorExtensionDescriptor.getExtension((Connector)this, String.class, null);
        }

        protected void disconnectImpl() throws IOException {
        }

        protected void writeImpl(Object data) throws IOException {
        }

        protected Object read() throws IOException {
            return null;
        }

        protected void error(String message, Throwable th) {
        }
    }

    @ExcludeFirst
    public static class MyConnectorExtension
    extends ConnectorExtensionDescriptor.DefaultConnectorExtension<String> {
        public MyConnectorExtension() {
            super(ConnectorExtensionDescriptorTest.ID, () -> ConnectorExtensionDescriptorTest.VALUE);
        }
    }
}

