/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.model;

import de.iip_ecosphere.platform.connectors.model.ModelInputConverter;
import de.iip_ecosphere.platform.connectors.model.ModelOutputConverter;
import de.iip_ecosphere.platform.transport.serialization.QualifiedElement;
import java.io.IOException;
import java.util.List;

public interface ModelAccess {
    public String topInstancesQName();

    public String getQSeparator();

    public String qName(String ... var1);

    public String iqName(String ... var1);

    public Object call(String var1, Object ... var2) throws IOException;

    public Object get(String var1) throws IOException;

    default public Object get(String qName, int lifetime) throws IOException {
        return this.get(qName);
    }

    default public int getInt(String qName) throws IOException {
        return this.getInputConverter().toInteger(this.get(qName));
    }

    default public float getFloat(String qName) throws IOException {
        return this.getInputConverter().toFloat(this.get(qName));
    }

    default public double getDouble(String qName) throws IOException {
        return this.getInputConverter().toDouble(this.get(qName));
    }

    default public long getLong(String qName) throws IOException {
        return this.getInputConverter().toLong(this.get(qName));
    }

    default public short getShort(String qName) throws IOException {
        return this.getInputConverter().toShort(this.get(qName));
    }

    default public byte getByte(String qName) throws IOException {
        return this.getInputConverter().toByte(this.get(qName));
    }

    default public boolean getBoolean(String qName) throws IOException {
        return this.getInputConverter().toBoolean(this.get(qName));
    }

    default public String getString(String qName) throws IOException {
        return this.getInputConverter().toString(this.get(qName));
    }

    default public <C> List<QualifiedElement<C>> getMultiValue(Class<C> eltCls, String name, boolean enumerated, String ... qualifiers) throws IOException {
        throw new IOException("Multi-valued operations are not implemented");
    }

    public void set(String var1, Object var2) throws IOException;

    default public void setInt(String qName, int value) throws IOException {
        this.set(qName, this.getOutputConverter().fromInteger(value));
    }

    default public void setLong(String qName, long value) throws IOException {
        this.set(qName, this.getOutputConverter().fromLong(value));
    }

    default public void setByte(String qName, byte value) throws IOException {
        this.set(qName, this.getOutputConverter().fromByte(value));
    }

    default public void setShort(String qName, short value) throws IOException {
        this.set(qName, this.getOutputConverter().fromShort(value));
    }

    default public void setBoolean(String qName, boolean value) throws IOException {
        this.set(qName, this.getOutputConverter().fromBoolean(value));
    }

    default public void setDouble(String qName, double value) throws IOException {
        this.set(qName, this.getOutputConverter().fromDouble(value));
    }

    default public void setFloat(String qName, float value) throws IOException {
        this.set(qName, this.getOutputConverter().fromFloat(value));
    }

    default public void setString(String qName, String value) throws IOException {
        this.set(qName, this.getOutputConverter().fromString(value));
    }

    default public void setMultiValue(String name, boolean enumerated, Object elements) throws IOException {
        if (elements instanceof List) {
            List tmp = (List)elements;
            boolean allElements = true;
            for (int i = 0; i < tmp.size(); ++i) {
                allElements = tmp.get(i) instanceof QualifiedElement;
            }
            if (allElements) {
                this.setMultiValue(name, enumerated, (List)elements);
            }
        }
    }

    default public void setMultiValue(String name, boolean enumerated, List<QualifiedElement<?>> elements) throws IOException {
        throw new IOException("Multi-valued operations are not implemented");
    }

    public <T> T getStruct(String var1, Class<T> var2) throws IOException;

    public void setStruct(String var1, Object var2) throws IOException;

    public void registerCustomType(Class<?> var1) throws IOException;

    public void monitor(String ... var1) throws IOException;

    public void monitor(int var1, String ... var2) throws IOException;

    public void monitorModelChanges() throws IOException;

    public void monitorModelChanges(int var1) throws IOException;

    public void setDetailNotifiedItem(boolean var1);

    public void useNotifications(boolean var1);

    default public ModelInputConverter getInputConverter() {
        return ModelInputConverter.INSTANCE;
    }

    default public ModelOutputConverter getOutputConverter() {
        return ModelOutputConverter.INSTANCE;
    }

    public ModelAccess stepInto(String var1) throws IOException;

    public ModelAccess stepOut();

    default public void dispose() {
    }
}

