/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class ConnectorParameterTest {
    @Test
    public void testDefaultConnectorParameter() {
        ConnectorParameter params = ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)"aaa", (int)1234).setSpecificSetting("XYZ", (Object)1).setSpecificSetting("XY0", (Object)"1").build();
        Assert.assertEquals((Object)"aaa", (Object)params.getHost());
        Assert.assertEquals((long)1234L, (long)params.getPort());
        Assert.assertEquals((Object)"", (Object)params.getApplicationId());
        Assert.assertEquals((Object)"", (Object)params.getApplicationDescription());
        Assert.assertEquals((Object)"", (Object)params.getEndpointPath());
        Assert.assertEquals((Object)ConnectorParameter.DEFAULT_SCHEMA, (Object)params.getSchema());
        Assert.assertEquals((long)2000L, (long)params.getKeepAlive());
        Assert.assertEquals((long)1000L, (long)params.getNotificationInterval());
        Assert.assertNull((Object)params.getIdentityToken(""));
        Assert.assertEquals((Object)1, (Object)params.getSpecificSetting("XYZ"));
        Assert.assertNull((Object)params.getSpecificSetting("XY1"));
        Assert.assertEquals((Object)"1", (Object)params.getSpecificStringSetting("XYZ"));
        Assert.assertNull((Object)params.getSpecificStringSetting("XY1"));
        Assert.assertEquals((long)1L, (long)params.getSpecificIntSetting("XYZ").intValue());
        Assert.assertEquals((long)1L, (long)params.getSpecificIntSetting("XY0").intValue());
        Assert.assertNull((Object)params.getSpecificIntSetting("XY1"));
        params.setSpecificIntSetting("XY0", i -> Assert.assertEquals((long)1L, (long)i.intValue()));
    }

    @Test
    public void testTransportTlsParameter() {
        ServerAddress addr = new ServerAddress(Schema.IGNORE, "local", 1234);
        String alias = "alias";
        ConnectorParameter params = ConnectorParameter.ConnectorParameterBuilder.newBuilder((ServerAddress)addr).build();
        Assert.assertEquals((Object)addr.getHost(), (Object)params.getHost());
        Assert.assertEquals((long)addr.getPort(), (long)params.getPort());
        Assert.assertEquals(null, (Object)params.getKeyAlias());
        Assert.assertFalse((boolean)params.getHostnameVerification());
        params = ConnectorParameter.ConnectorParameterBuilder.newBuilder((ServerAddress)addr).setHostnameVerification(false).build();
        Assert.assertEquals((Object)addr.getHost(), (Object)params.getHost());
        Assert.assertEquals((long)addr.getPort(), (long)params.getPort());
        Assert.assertEquals(null, (Object)params.getKeyAlias());
        Assert.assertFalse((boolean)params.getHostnameVerification());
        params = ConnectorParameter.ConnectorParameterBuilder.newBuilder((ServerAddress)addr).setKeyAlias(alias).setHostnameVerification(true).build();
        Assert.assertEquals((Object)addr.getHost(), (Object)params.getHost());
        Assert.assertEquals((long)addr.getPort(), (long)params.getPort());
        Assert.assertEquals((Object)alias, (Object)params.getKeyAlias());
        Assert.assertTrue((boolean)params.getHostnameVerification());
    }

    @Test
    public void testCustomConnectorParameter() {
        byte[] bytes = "aaa".getBytes();
        HashMap<String, IdentityToken> tokens = new HashMap<String, IdentityToken>();
        tokens.put("a", IdentityToken.IdentityTokenBuilder.newBuilder((String)"a", (String)"b", (byte[])bytes).build());
        tokens.put("i", IdentityToken.IdentityTokenBuilder.newBuilder((String)"i", (String)"j", (byte[])bytes).setIssuedToken(bytes, "abc").build());
        tokens.put("u", IdentityToken.IdentityTokenBuilder.newBuilder((String)"u", (String)"k", (byte[])bytes).setUsernameToken("me", bytes, "abc").build());
        tokens.put("x", IdentityToken.IdentityTokenBuilder.newBuilder((String)"u", (String)"k", (byte[])bytes).setX509Token(bytes).build());
        ConnectorParameter params = ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)"aaa", (int)1234, (Schema)Schema.TCP).setApplicationInformation("aI", "aD").setAutoApplicationId(false).setEndpointPath("epp/").setKeepAlive(2345).setNotificationInterval(9999).setRequestTimeout(3421).setIdentities(tokens).build();
        Assert.assertEquals((Object)"aaa", (Object)params.getHost());
        Assert.assertEquals((long)1234L, (long)params.getPort());
        Assert.assertEquals((Object)Schema.TCP, (Object)params.getSchema());
        Assert.assertEquals((Object)"aI", (Object)params.getApplicationId());
        Assert.assertEquals((Object)"aD", (Object)params.getApplicationDescription());
        Assert.assertFalse((boolean)params.getAutoApplicationId());
        Assert.assertEquals((Object)"epp/", (Object)params.getEndpointPath());
        Assert.assertEquals((long)2345L, (long)params.getKeepAlive());
        Assert.assertEquals((long)9999L, (long)params.getNotificationInterval());
        Assert.assertEquals((long)3421L, (long)params.getRequestTimeout());
        Assert.assertTrue((tokens.get("a") == params.getIdentityToken("a") ? 1 : 0) != 0);
        Assert.assertTrue((tokens.get("i") == params.getIdentityToken("i") ? 1 : 0) != 0);
        Assert.assertTrue((tokens.get("u") == params.getIdentityToken("u") ? 1 : 0) != 0);
        Assert.assertTrue((tokens.get("x") == params.getIdentityToken("x") ? 1 : 0) != 0);
        params = ConnectorParameter.ConnectorParameterBuilder.newBuilder((ConnectorParameter)params, (String)"local", null, null).build();
        Assert.assertEquals((Object)"local", (Object)params.getHost());
        Assert.assertEquals((long)1234L, (long)params.getPort());
        Assert.assertEquals((Object)Schema.TCP, (Object)params.getSchema());
        Assert.assertEquals((Object)"aI", (Object)params.getApplicationId());
        Assert.assertEquals((Object)"aD", (Object)params.getApplicationDescription());
        Assert.assertFalse((boolean)params.getAutoApplicationId());
        Assert.assertEquals((Object)"epp/", (Object)params.getEndpointPath());
        Assert.assertEquals((long)2345L, (long)params.getKeepAlive());
        Assert.assertEquals((long)9999L, (long)params.getNotificationInterval());
        Assert.assertEquals((long)3421L, (long)params.getRequestTimeout());
        Assert.assertTrue((tokens.get("a") == params.getIdentityToken("a") ? 1 : 0) != 0);
        Assert.assertTrue((tokens.get("i") == params.getIdentityToken("i") ? 1 : 0) != 0);
        Assert.assertTrue((tokens.get("u") == params.getIdentityToken("u") ? 1 : 0) != 0);
        Assert.assertTrue((tokens.get("x") == params.getIdentityToken("x") ? 1 : 0) != 0);
        ServerAddress addr = new ServerAddress(Schema.TCP, "aaa", 1234);
        params = ConnectorParameter.ConnectorParameterBuilder.newBuilder((ServerAddress)addr).build();
        Assert.assertEquals((Object)addr.getHost(), (Object)params.getHost());
        Assert.assertEquals((long)addr.getPort(), (long)params.getPort());
        Assert.assertEquals((Object)addr.getSchema(), (Object)params.getSchema());
    }
}

