/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.AbstractConnector;
import de.iip_ecosphere.platform.connectors.AbstractPluginConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.AdapterSelector;
import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.MachineConnector;
import de.iip_ecosphere.platform.connectors.model.AbstractModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import java.io.IOException;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Supplier;
import test.de.iip_ecosphere.platform.connectors.ModelDataType;
import test.de.iip_ecosphere.platform.connectors.MyModelConnector;

@MachineConnector(hasModel=true, supportsEvents=false, supportsHierarchicalQNames=true, supportsModelCalls=false, supportsModelProperties=false, supportsModelStructs=false, specificSettings={})
public class MyModelConnector<CO, CI>
extends AbstractConnector<Object, Object, CO, CI> {
    public static final String NAME = "MyModelConnector";
    private Deque<Object> offers = new LinkedBlockingDeque<Object>();
    private Deque<Object> received = new LinkedBlockingDeque<Object>();
    private ConnectorParameter params;

    @SafeVarargs
    public MyModelConnector(ProtocolAdapter<Object, Object, CO, CI> ... adapter) {
        super(adapter);
        this.configureModelAccess((ModelAccess)new MyModelAccess(this.params));
    }

    protected void connectImpl(ConnectorParameter params) throws IOException {
        this.params = params;
    }

    public void disconnectImpl() throws IOException {
    }

    public void dispose() {
    }

    public String getName() {
        return NAME;
    }

    protected void writeImpl(Object data) throws IOException {
        this.received.offer(data);
    }

    protected Object read() throws IOException {
        return this.offers.pollFirst();
    }

    protected void error(String message, Throwable th) {
        System.out.println(message);
    }

    public void testTrigger() throws IOException {
        Object trigger = new Object();
        if (this.isPolling()) {
            this.offers.offer(trigger);
        } else {
            this.received("", trigger);
        }
    }

    public Object pollReceived() {
        return this.received.poll();
    }

    public String supportedEncryption() {
        return null;
    }

    public String enabledEncryption() {
        return null;
    }

    private class MyModelAccess
    extends AbstractModelAccess {
        private Map<String, test.de.iip_ecosphere.platform.connectors.MyModelConnector$MyModelAccess.Entry> model;
        private Map<String, test.de.iip_ecosphere.platform.connectors.MyModelConnector$MyModelAccess.Entry> structs;
        private ConnectorParameter params;

        protected MyModelAccess(ConnectorParameter params) {
            super((AbstractModelAccess.NotificationChangedListener)MyModelConnector.this);
            this.model = new HashMap<String, test.de.iip_ecosphere.platform.connectors.MyModelConnector$MyModelAccess.Entry>();
            this.structs = new HashMap<String, test.de.iip_ecosphere.platform.connectors.MyModelConnector$MyModelAccess.Entry>();
            this.params = params;
        }

        public String topInstancesQName() {
            return "";
        }

        public String getQSeparator() {
            return "/";
        }

        public ModelDataType call(String qName, Object ... args) throws IOException {
            return null;
        }

        public Object get(String qName) throws IOException {
            if (this.model.containsKey(qName)) {
                return ((Entry)this.model.get((Object)qName)).value;
            }
            throw new IOException("Element " + qName + " does not exist");
        }

        public void set(String qName, Object value) throws IOException {
            Entry entry;
            if (this.structs.containsKey(qName)) {
                throw new IOException(qName + " is already registered for a struct");
            }
            if (this.model.containsKey(qName)) {
                entry = (Entry)this.model.get(qName);
                entry.value = value;
            } else {
                entry = new Entry(value, false);
                this.model.put(qName, (test.de.iip_ecosphere.platform.connectors.MyModelConnector$MyModelAccess.Entry)entry);
            }
            this.notify(entry);
        }

        public <T> T getStruct(String qName, Class<T> type) throws IOException {
            Entry ent = (Entry)this.structs.get(qName);
            if (null == ent) {
                throw new IOException("Element " + qName + " does not exist");
            }
            if (!type.isInstance(ent.value)) {
                throw new IOException("Cannot cast " + qName + " struct to " + type.getName());
            }
            T result = type.cast(ent.value);
            return result;
        }

        public void setStruct(String qName, Object value) throws IOException {
            Entry entry;
            if (this.model.containsKey(qName)) {
                throw new IOException(qName + " is already registered for primitive property");
            }
            if (this.structs.containsKey(qName)) {
                entry = (Entry)this.structs.get(qName);
                entry.value = value;
            } else {
                entry = new Entry(value, false);
                this.structs.put(qName, (test.de.iip_ecosphere.platform.connectors.MyModelConnector$MyModelAccess.Entry)entry);
            }
            this.notify(entry);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void notify(Entry entry) {
            if (entry.notify) {
                try {
                    MyModelConnector.this.received("", entry.value);
                }
                catch (IOException e) {
                    MyModelConnector.this.error("While notifying", e);
                }
            }
        }

        public void registerCustomType(Class<?> cls) throws IOException {
        }

        public void monitor(int notificationInterval, String ... qName) throws IOException {
            for (String n : qName) {
                Entry me = (Entry)this.model.get(n);
                if (null != me) {
                    me.notify = true;
                    continue;
                }
                Entry se = (Entry)this.structs.get(n);
                if (null != se) {
                    se.notify = true;
                    continue;
                }
                throw new IOException("Element " + String.valueOf(qName) + " does not exist");
            }
        }

        public void monitorModelChanges(int notificationInterval) throws IOException {
        }

        public ConnectorParameter getConnectorParameter() {
            return this.params;
        }

        public ModelAccess stepInto(String name) throws IOException {
            return this;
        }

        public ModelAccess stepOut() {
            return this;
        }

        private class Entry {
            private Object value;
            private boolean notify;

            private Entry(Object value, boolean notify) {
                this.value = value;
                this.notify = notify;
            }
        }
    }

    public static class Descriptor
    extends AbstractPluginConnectorDescriptor<Object, Object> {
        public String getName() {
            return MyModelConnector.NAME;
        }

        public Class<?> getConnectorType() {
            return MyModelConnector.class;
        }

        protected String initId(String id) {
            return "connector-test-myModelConnector";
        }

        protected <O, I, CO, CI, S extends AdapterSelector<Object, Object, CO, CI>, A extends ProtocolAdapter<Object, Object, CO, CI>> Connector<Object, Object, CO, CI> createConnectorImpl(S selector, Supplier<ConnectorParameter> params, A ... adapter) {
            return new MyModelConnector((ProtocolAdapter<Object, Object, CO, CI>[])adapter);
        }
    }
}

