/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.AbstractConnector;
import de.iip_ecosphere.platform.connectors.AdapterSelector;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Supplier;

public abstract class AbstractThreadedConnector<O, I, CO, CI, M extends ModelAccess>
extends AbstractConnector<O, I, CO, CI> {
    private Timer timer;
    private Supplier<M> modelAccessSupplier;
    private Map<Thread, M> accesses = new HashMap<Thread, M>();
    private TimerTask cleanupTask;
    private int cleanupPeriod = 5000;

    @SafeVarargs
    protected AbstractThreadedConnector(ProtocolAdapter<O, I, CO, CI> ... adapter) {
        super(adapter);
    }

    @SafeVarargs
    protected AbstractThreadedConnector(AdapterSelector<O, I, CO, CI> selector, ProtocolAdapter<O, I, CO, CI> ... adapter) {
        super(selector, adapter);
    }

    protected void setModelAccessSupplier(Supplier<M> modelAccessSupplier) {
        if (null != modelAccessSupplier) {
            this.modelAccessSupplier = modelAccessSupplier;
            this.configureModelAccess((ModelAccess)modelAccessSupplier.get());
        }
    }

    protected Supplier<M> getModelAccessSupplier() {
        return this.modelAccessSupplier;
    }

    private M obtainModelAccess(Thread thread) {
        ModelAccess acc = (ModelAccess)this.accesses.get(thread);
        if (null == acc) {
            acc = (ModelAccess)this.modelAccessSupplier.get();
            this.accesses.put(thread, acc);
        }
        return (M)acc;
    }

    @Override
    protected ProtocolAdapter<O, I, CO, CI> configureAdapter(ProtocolAdapter<O, I, CO, CI> adapter) {
        if (this.modelAccessSupplier != null) {
            adapter.setModelAccess((ModelAccess)this.obtainModelAccess(Thread.currentThread()));
        }
        return adapter;
    }

    @Override
    public void connect(ConnectorParameter params) throws IOException {
        this.cleanupTask = new TimerTask(){

            @Override
            public void run() {
                ArrayList<Thread> threads = new ArrayList<Thread>(AbstractThreadedConnector.this.accesses.keySet());
                for (Thread t : threads) {
                    if (t.isAlive()) continue;
                    ((ModelAccess)AbstractThreadedConnector.this.accesses.remove(t)).dispose();
                }
            }
        };
        if (null == this.timer) {
            this.timer = new Timer();
        }
        this.timer.schedule(this.cleanupTask, 0L, (long)this.cleanupPeriod);
        super.connect(params);
    }

    protected void setCleanupPeriod(int cleanupPeriod) {
        if (cleanupPeriod > 0) {
            this.cleanupPeriod = cleanupPeriod;
        }
    }

    public int getCleanupPeriod() {
        return this.cleanupPeriod;
    }

    @Override
    protected void uninstallPollTask() {
        if (null != this.cleanupTask) {
            this.cleanupTask.cancel();
        }
        if (null != this.timer) {
            this.timer.cancel();
        }
        super.uninstallPollTask();
    }

    protected M getModelAccess() {
        return this.getModelAccess(Thread.currentThread());
    }

    protected M getModelAccess(Thread thread) {
        return this.obtainModelAccess(thread);
    }
}

