/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.types.AbstractConnectorOutputTypeTranslator;
import java.io.IOException;
import org.junit.Assert;
import test.de.iip_ecosphere.platform.connectors.MachineData;

public class MachineDataOutputTranslator<S>
extends AbstractConnectorOutputTypeTranslator<S, MachineData> {
    private boolean withNotifications;
    private Class<? extends S> sourceType;
    private OutputCustomizer customizer;

    public MachineDataOutputTranslator(boolean withNotifications, Class<? extends S> sourceType, OutputCustomizer customizer) {
        this.withNotifications = withNotifications;
        this.sourceType = sourceType;
        this.customizer = customizer;
    }

    public MachineData to(Object source) throws IOException {
        ModelAccess access = this.getModelAccess();
        if (this.customizer.assertNotExistingProperties()) {
            try {
                access.get("abxy");
                Assert.fail((String)"Property shall not exist");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                access.get("ab" + access.getQSeparator() + "abxy");
                Assert.fail((String)"Property shall not exist");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                access.get("machine" + access.getQSeparator() + "abxy");
                Assert.fail((String)"Property shall not exist");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String vendor = this.customizer.getVendor(access);
        return new MachineData(access.getInputConverter().toInteger(access.get(this.customizer.getQNameVarLotSize())), access.getInputConverter().toDouble(access.get(this.customizer.getQNameVarPowerConsumption())), vendor);
    }

    public void initializeModelAccess() throws IOException {
        ModelAccess access = this.getModelAccess();
        access.useNotifications(this.withNotifications);
        this.customizer.initializeModelAccess(access, this.withNotifications);
    }

    public Class<? extends S> getSourceType() {
        return this.sourceType;
    }

    public Class<? extends MachineData> getTargetType() {
        return MachineData.class;
    }

    public static interface OutputCustomizer {
        public void initializeModelAccess(ModelAccess var1, boolean var2) throws IOException;

        public String getVendor(ModelAccess var1) throws IOException;

        public String getTopLevelModelPartName();

        public String getQNameVarLotSize();

        public String getQNameVarPowerConsumption();

        default public boolean assertNotExistingProperties() {
            return true;
        }
    }
}

