/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.dependencies;

import de.iip_ecosphere.platform.tools.maven.python.FilesetUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugins.dependency.fromConfiguration.UnpackMojo;
import org.apache.maven.shared.model.fileset.FileSet;

@Mojo(name="unpack", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresProject=false, threadSafe=true)
public class CleaningUnpackMojo
extends UnpackMojo {
    @Parameter(required=false)
    private FileSet cleanup;
    @Parameter(property="unpack.initiallyAllowed", required=false, defaultValue="")
    private String initiallyAllowed;
    @Parameter(property="unpack.initiallyAllowedFile", required=false, defaultValue="")
    private File initiallyAllowedFile;
    @Parameter(property="unpack.force", required=false, defaultValue="false")
    private boolean force;
    @Parameter(property="unpack.forceCleanup", required=false, defaultValue="false")
    private boolean forceCleanup;
    @Parameter(property="unpack.skipIfExists", required=false, defaultValue="")
    private File skipIfExists;
    @Parameter(property="unpack.logCleanup", required=false, defaultValue="false")
    private boolean logCleanup;

    private boolean hasInitiallyAllowed() {
        return this.initiallyAllowed != null || this.initiallyAllowedFile != null;
    }

    public static Set<String> getInitiallyAllowed(String initiallyAllowed, File initiallyAllowedFile, Log log) {
        Object tmp;
        HashSet<String> allowed = new HashSet<String>();
        if (null != initiallyAllowedFile) {
            try {
                List<String> allLines = Files.readAllLines(initiallyAllowedFile.toPath());
                allowed.addAll(allLines);
                allowed.add(initiallyAllowedFile.toString());
                log.info((CharSequence)("Taking initially allowed files from " + String.valueOf(initiallyAllowedFile)));
            }
            catch (IOException e) {
                log.warn((CharSequence)("Cannot read initially allowed files from " + String.valueOf(initiallyAllowedFile) + ": " + e.getMessage()));
            }
        }
        if (null != initiallyAllowed) {
            tmp = initiallyAllowed.replace(";", ":");
            log.info((CharSequence)("Taking initially allowed files from POM " + initiallyAllowed));
            Collections.addAll(allowed, ((String)tmp).split(":"));
        }
        tmp = new HashSet();
        for (String a : allowed) {
            tmp.add(FilenameUtils.normalize((String)a));
        }
        return tmp;
    }

    public static boolean matches(File file, Collection<String> allowed) {
        for (String a : allowed) {
            if (!FilenameUtils.wildcardMatch((String)FilenameUtils.normalize((String)file.toString()), (String)a, (IOCase)IOCase.SENSITIVE)) continue;
            return true;
        }
        return false;
    }

    protected Log getCleanupLog() {
        return this.logCleanup ? this.getLog() : null;
    }

    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        boolean execute;
        if (this.forceCleanup) {
            FilesetUtils.deletePaths((FileSet)this.cleanup, (Log)this.getCleanupLog());
        }
        if (this.force) {
            execute = true;
        } else {
            execute = false;
            for (ArtifactItem ai : this.getArtifactItems()) {
                boolean outDirExists = ai.getOutputDirectory().exists();
                if ((execute |= ai.isNeedsProcessing() || !outDirExists) || !outDirExists || !this.hasInitiallyAllowed()) continue;
                Set<String> allowed = CleaningUnpackMojo.getInitiallyAllowed(this.initiallyAllowed, this.initiallyAllowedFile, this.getLog());
                this.getLog().info((CharSequence)("Output directory " + String.valueOf(ai.getOutputDirectory()) + " exists. Checking for initially allowed files: " + String.valueOf(allowed)));
                execute = true;
                for (File f : ai.getOutputDirectory().listFiles()) {
                    if (!CleaningUnpackMojo.matches(f, allowed)) continue;
                    this.getLog().info((CharSequence)("Disabling execution as " + String.valueOf(f) + " is not initially allowed"));
                    execute = false;
                }
            }
            if (this.skipIfExists != null && this.skipIfExists.toString().length() > 0 && this.skipIfExists.exists()) {
                this.getLog().info((CharSequence)("Disabling execution as " + String.valueOf(this.skipIfExists) + " exists"));
                execute = false;
            }
        }
        if (execute) {
            if (!this.forceCleanup) {
                FilesetUtils.deletePaths((FileSet)this.cleanup, (Log)this.getCleanupLog());
            }
            super.doExecute();
        }
    }

    public void setForceCleanup(boolean forceCleanup) {
        this.forceCleanup = forceCleanup;
    }

    public void setCleanup(FileSet cleanup) {
        this.cleanup = cleanup;
    }

    public void setSkipIfExists(File skipIfExists) {
        this.skipIfExists = skipIfExists;
    }

    public File skipIfExists() {
        return this.skipIfExists;
    }

    public void setLogCleanup(boolean logCleanup) {
        this.logCleanup = logCleanup;
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

