/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.dependencies;

import de.iip_ecosphere.platform.tools.maven.dependencies.Resolver;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="build-classpath", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class BuildClasspathMojo
extends org.apache.maven.plugins.dependency.fromDependencies.BuildClasspathMojo {
    private static final Function<String, String> TO_WIN = s -> null == s ? null : s.replace('/', '\\');
    private static final Function<String, String> TO_LINUX = s -> null == s ? null : s.replace('\\', '/');
    @Parameter(property="mdep.outputFile")
    private File outputFile;
    @Parameter(property="mdep.pathSeparator", defaultValue="")
    private String pathSeparator;
    @Parameter(property="mdep.prefix")
    private String prefix;
    @Parameter(property="mdep.localRepoProperty", defaultValue="")
    private String localRepoProperty;
    @Parameter(property="mdep.fileSeparator", defaultValue="")
    private String fileSeparator;
    @Parameter(property="mdep.cleanup", defaultValue="true")
    private boolean cleanup;
    @Parameter(required=false)
    private List<String> befores;
    @Parameter(required=false)
    private List<String> prepends;
    @Parameter(required=false)
    private List<String> appends;
    @Parameter(required=false)
    private List<String> afters;
    @Parameter(property="mdep.lineSeparator", defaultValue="\n")
    private String lineSeparator;
    @Parameter(required=false)
    private boolean rollout;
    @Parameter(property="mdep.addTestArtifact", defaultValue="false")
    private boolean addTestArtifact;
    @Parameter(property="mdep.addAppLoader", defaultValue="false")
    private boolean addAppLoader;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepositories;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteArtifactRepositories;
    @Component
    private RepositorySystem repoSystem;
    private Set<String> oldEntries;

    public void setOutputFile(File outputFile) {
        super.setOutputFile(outputFile);
        this.outputFile = outputFile;
    }

    public void setFileSeparator(String theFileSeparator) {
        super.setFileSeparator(theFileSeparator);
        this.fileSeparator = theFileSeparator;
    }

    public void setPathSeparator(String thePathSeparator) {
        super.setPathSeparator(thePathSeparator);
        this.pathSeparator = thePathSeparator;
    }

    public void setLocalRepoProperty(String localRepoProperty) {
        super.setLocalRepoProperty(localRepoProperty);
        this.localRepoProperty = localRepoProperty;
    }

    public void setPrefix(String thePrefix) {
        super.setPrefix(thePrefix);
        this.prefix = thePrefix;
    }

    public void setPrepends(List<String> prepends) {
        this.prepends = prepends;
    }

    public void setBefores(List<String> befores) {
        this.befores = befores;
    }

    public List<String> getBefores() {
        return this.befores;
    }

    static <C extends Collection<String>> C readEntries(String contents, C result) {
        StringTokenizer entries = new StringTokenizer(contents, ":;");
        while (entries.hasMoreTokens()) {
            result.add((String)entries.nextToken());
        }
        return result;
    }

    static Set<String> readEntriesToSet(String contents) {
        return BuildClasspathMojo.readEntries(contents, new HashSet());
    }

    static List<String> readEntriesToList(String contents) {
        return BuildClasspathMojo.readEntries(contents, new ArrayList());
    }

    private static List<String> copy(List<String> list, Function<String, String> transform) {
        List<String> result = list;
        if (result != null) {
            result = new ArrayList<String>(list.size());
            for (String e : list) {
                result.add(transform.apply(e));
            }
        }
        return result;
    }

    protected void doExecute() throws MojoExecutionException {
        this.doExecuteImpl();
        if (this.rollout) {
            File initialOutputFile = this.outputFile;
            String initialPrefix = this.prefix;
            String initialLocalRepoProperty = this.localRepoProperty;
            List<String> initialAppends = this.appends;
            List<String> initialPrepends = this.prepends;
            this.outputFile = new File(initialOutputFile.toString() + "-win");
            this.setOutputFile(this.outputFile);
            this.setPathSeparator(";");
            this.setFileSeparator("\\");
            this.setLocalRepoProperty(TO_WIN.apply(initialLocalRepoProperty));
            this.setPrefix(TO_WIN.apply(initialPrefix));
            this.appends = BuildClasspathMojo.copy(initialAppends, TO_WIN);
            this.prepends = BuildClasspathMojo.copy(initialPrepends, TO_WIN);
            this.lineSeparator = "\r\n";
            this.adjustTo(TO_WIN);
            this.doExecuteImpl();
            this.outputFile = new File(initialOutputFile.toString() + "-linux");
            this.setOutputFile(this.outputFile);
            this.setPathSeparator(":");
            this.setFileSeparator("/");
            this.setLocalRepoProperty(TO_LINUX.apply(initialLocalRepoProperty));
            this.setPrefix(TO_LINUX.apply(initialPrefix));
            this.appends = BuildClasspathMojo.copy(initialAppends, TO_LINUX);
            this.prepends = BuildClasspathMojo.copy(initialPrepends, TO_LINUX);
            this.adjustTo(TO_LINUX);
            this.lineSeparator = "\n";
            this.doExecuteImpl();
        }
    }

    public void adjustTo(Function<String, String> func) {
    }

    private void handleSpringLoader() {
        Resolver resolver;
        File file;
        if (this.addAppLoader && null != (file = (resolver = new Resolver(this.repoSystem, this.repoSession, this.remoteRepositories, this.getLog())).resolveSpringBootLoader(this.getProject()))) {
            if (null == this.appends) {
                this.appends = new ArrayList<String>();
            }
            Object name = file.getName();
            if (null != this.prefix) {
                if (!this.prefix.endsWith(this.fileSeparator)) {
                    this.prefix = this.prefix + this.fileSeparator;
                }
                name = this.prefix + (String)name;
            }
            this.appends.add((String)name);
        }
    }

    private void doExecuteImpl() throws MojoExecutionException {
        if (this.cleanup && this.outputFile.exists()) {
            try {
                this.oldEntries = BuildClasspathMojo.readEntriesToSet(FileUtils.readFileToString((File)this.outputFile, (Charset)Charset.defaultCharset()));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Reading: " + e.getMessage()));
            }
        }
        super.doExecute();
        this.handleSpringLoader();
        boolean hasPrepends = this.prepends != null && !this.prepends.isEmpty();
        boolean hasAppends = this.appends != null && !this.appends.isEmpty();
        boolean hasBefores = this.befores != null && !this.befores.isEmpty();
        boolean hasAfters = this.afters != null && !this.afters.isEmpty();
        boolean hasAdditionalContents = hasPrepends || hasAppends || hasBefores || hasAfters;
        MavenProject project = this.getProject();
        String self = project.getGroupId().replace(".", "/") + "/" + project.getArtifactId() + "/" + project.getVersion() + "/" + project.getArtifactId() + "-" + project.getVersion();
        String selfTest = self + "-tests.jar";
        self = self + ".jar";
        if (hasAdditionalContents && this.outputFile != null) {
            try {
                Object tmp;
                Object content = FileUtils.readFileToString((File)this.outputFile, (Charset)Charset.defaultCharset());
                if (hasPrepends) {
                    tmp = "";
                    for (String s : this.prepends) {
                        s = s.replace("${self}", self);
                        s = s.replace("${self-test}", selfTest);
                        tmp = (String)tmp + s + this.pathSeparator;
                    }
                    content = (String)tmp + (String)content;
                }
                if (hasAppends) {
                    tmp = "";
                    for (String s : this.appends) {
                        s = s.replace("${self}", self);
                        s = s.replace("${self-test}", selfTest);
                        tmp = (String)tmp + this.pathSeparator + s;
                    }
                    content = (String)content + (String)tmp;
                }
                if (hasBefores) {
                    content = String.join((CharSequence)this.lineSeparator, this.befores) + this.lineSeparator + (String)content;
                }
                if (hasAfters) {
                    content = (String)content + this.lineSeparator + String.join((CharSequence)this.lineSeparator, this.afters);
                }
                FileUtils.write((File)this.outputFile, (CharSequence)content, (Charset)Charset.defaultCharset());
                this.getLog().info((CharSequence)("Appended/prepended to: " + String.valueOf(this.outputFile)));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Appending/prepending: " + e.getMessage()));
            }
        }
        if (this.cleanup && this.outputFile.exists() && this.oldEntries != null) {
            try {
                Set<String> newEntries = BuildClasspathMojo.readEntriesToSet(FileUtils.readFileToString((File)this.outputFile, (Charset)Charset.defaultCharset()));
                for (String e : newEntries) {
                    this.oldEntries.remove(e);
                }
                for (String e : this.oldEntries) {
                    this.getLog().info((CharSequence)("Cleaning outdated classpath entry " + e));
                    FileUtils.deleteQuietly((File)new File(e));
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Reading: " + e.getMessage()));
            }
        }
    }

    public ProjectBuildingRequest newResolveArtifactProjectBuildingRequest() {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.remoteArtifactRepositories);
        return buildingRequest;
    }
}

