/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.dependencies;

import de.iip_ecosphere.platform.tools.maven.dependencies.BuildClasspathMojo;
import de.iip_ecosphere.platform.tools.maven.dependencies.Layers;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="build-plugin-classpath", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class BuildPluginClasspathMojo
extends BuildClasspathMojo {
    public static final String KEY_PREFIX = "# prefix: ";
    public static final String KEY_UNPACK_MODE = "# unpackMode: ";
    public static final String KEY_SETUP_DESCRIPTOR = "# setupDescriptor: ";
    public static final String KEY_PLUGIN_IDS = "# pluginIds: ";
    public static final String KEY_SEQUENCE_NR = "# sequenceNr: ";
    private final String prefix = "target/jars";
    @Parameter(property="mdep.addTestArtifact", defaultValue="false")
    private boolean addTestArtifact;
    @Parameter(property="mdep.unpackMode", defaultValue="jars")
    private String unpackMode;
    @Parameter(property="mdep.setupDescriptor", defaultValue="FolderClasspath")
    private String setupDescriptor;
    @Parameter(property="mdep.pluginIds", defaultValue="")
    private List<String> pluginIds;
    @Parameter(required=false)
    private boolean asTest;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDirectory;

    private String getRelTargetDirectory() {
        String result = this.targetDirectory.getName();
        File home = new File(System.getProperty("user.dir"));
        String homePath = home.getAbsolutePath();
        String targetPath = this.targetDirectory.getAbsolutePath();
        try {
            homePath = home.getCanonicalPath();
            targetPath = this.targetDirectory.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (targetPath.startsWith(homePath)) {
            result = targetPath.substring(homePath.length() + 1);
        }
        return result;
    }

    private String composeMyArtifact(String classifier, String extension) {
        Object object = classifier = null == classifier ? "" : classifier;
        if (((String)classifier).length() > 0 && !((String)classifier).startsWith("-")) {
            classifier = "-" + (String)classifier;
        }
        Object object2 = extension = null == extension || ((String)extension).length() == 0 ? "jar" : extension;
        if (!((String)extension).startsWith(".")) {
            extension = "." + (String)extension;
        }
        return this.getRelTargetDirectory() + "/" + this.getProject().getGroupId() + "." + this.getProject().getArtifactId() + "-" + this.getProject().getVersion() + (String)classifier + (String)extension;
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        this.excludeArtifactIds = Layers.getExcludeArtifactIds(this.getProject().getArtifactId(), this.excludeArtifactIds, this.asTest, this.getLog());
        this.setOutputFile(new File(this.targetDirectory, "jars" + (this.asTest ? "-test" : "") + "/classpath"));
        this.setPrependGroupId(true);
        this.overWriteIfNewer = true;
        this.setLocalRepoProperty("target/jars");
        this.setPrefix("target/jars");
        this.setFileSeparator("/");
        this.setPathSeparator(":");
        if (null == this.includeScope || this.includeScope.length() == 0) {
            this.includeScope = this.addTestArtifact || this.asTest ? "test" : "compile";
        }
        ArrayList<String> prepends = new ArrayList<String>();
        prepends.add(this.composeMyArtifact("", "jar"));
        if (this.addTestArtifact || this.asTest) {
            prepends.add(this.composeMyArtifact("tests", "jar"));
        }
        this.setPrepends(prepends);
        this.composeBefores(null);
        super.doExecute();
    }

    @Override
    public void adjustTo(Function<String, String> func) {
        this.composeBefores(func);
    }

    private void composeBefores(Function<String, String> func) {
        ArrayList<String> befores = new ArrayList<String>();
        befores.add(KEY_PREFIX + (null != func ? func.apply("target/jars") : "target/jars"));
        befores.add(KEY_UNPACK_MODE + this.unpackMode);
        befores.add(KEY_SETUP_DESCRIPTOR + this.setupDescriptor);
        if (this.pluginIds != null && this.pluginIds.size() > 0) {
            befores.add(KEY_PLUGIN_IDS + String.join((CharSequence)", ", this.pluginIds));
        }
        this.setBefores(befores);
    }
}

