/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.dependencies;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.fromDependencies.BuildClasspathMojo;
import org.apache.maven.plugins.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ProjectTransitivityFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="diff-classpath", requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class DiffClasspathMojo
extends BuildClasspathMojo {
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter(property="mdep.outputFile", required=true)
    private File outputFile;
    @Parameter(property="mdep.pathSeparator", defaultValue="", required=true)
    private String pathSeparator;
    @Parameter(property="mdep.rootCoordinates", required=true)
    private Set<String> rootCoordinates;

    public void setOutputFile(File outputFile) {
        super.setOutputFile(outputFile);
        this.outputFile = outputFile;
    }

    public void setPathSeparator(String thePathSeparator) {
        super.setPathSeparator(thePathSeparator);
        this.pathSeparator = thePathSeparator;
    }

    private String getCoordinate(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion();
    }

    private String getCoordinate(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
    }

    private void collectDependencies(Artifact artifact, Map<String, Artifact> coordMapping, Set<Artifact> artifacts) throws MojoExecutionException {
        MavenProject prj = this.buildProjectFromArtifact(artifact);
        for (Dependency d : prj.getDependencies()) {
            Artifact a = coordMapping.get(this.getCoordinate(d));
            if (null == a || artifacts.contains(a)) continue;
            artifacts.add(a);
            this.collectDependencies(a, coordMapping, artifacts);
        }
    }

    protected DependencyStatusSets getDependencySets(boolean stopOnFailure, boolean includeParents) throws MojoExecutionException {
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new ProjectTransitivityFilter(this.getProject().getDependencyArtifacts(), this.excludeTransitive));
        if ("test".equals(this.excludeScope)) {
            throw new MojoExecutionException("Excluding every artifact inside 'test' resolution scope means excluding everything: you probably want includeScope='compile', read parameters documentation for detailed explanations");
        }
        filter.addFilter((ArtifactsFilter)new ScopeFilter(DependencyUtil.cleanToBeTokenizedString((String)this.includeScope), DependencyUtil.cleanToBeTokenizedString((String)this.excludeScope)));
        filter.addFilter((ArtifactsFilter)new TypeFilter(DependencyUtil.cleanToBeTokenizedString((String)this.includeTypes), DependencyUtil.cleanToBeTokenizedString((String)this.excludeTypes)));
        filter.addFilter((ArtifactsFilter)new ClassifierFilter(DependencyUtil.cleanToBeTokenizedString((String)this.includeClassifiers), DependencyUtil.cleanToBeTokenizedString((String)this.excludeClassifiers)));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(DependencyUtil.cleanToBeTokenizedString((String)this.includeGroupIds), DependencyUtil.cleanToBeTokenizedString((String)this.excludeGroupIds)));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(DependencyUtil.cleanToBeTokenizedString((String)this.includeArtifactIds), DependencyUtil.cleanToBeTokenizedString((String)this.excludeArtifactIds)));
        Set artifacts = this.getProject().getArtifacts();
        this.getLog().info((CharSequence)("Resolving dependencies of " + String.valueOf(this.rootCoordinates)));
        HashMap<String, Artifact> coordMapping = new HashMap<String, Artifact>();
        artifacts.forEach(a -> coordMapping.put(this.getCoordinate((Artifact)a), (Artifact)a));
        artifacts.removeIf(a -> {
            String coordinate = this.getCoordinate((Artifact)a);
            return !this.rootCoordinates.contains(coordinate);
        });
        for (Artifact dep : new ArrayList(artifacts)) {
            this.collectDependencies(dep, coordMapping, artifacts);
        }
        if (includeParents) {
            for (Artifact dep : new ArrayList(artifacts)) {
                this.addParentArtifacts(this.buildProjectFromArtifact(dep), artifacts);
            }
            this.addParentArtifacts(this.getProject(), artifacts);
        }
        try {
            artifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        DependencyStatusSets status = StringUtils.isNotEmpty((String)this.classifier) ? this.getClassifierTranslatedDependencies(artifacts, stopOnFailure) : this.filterMarkedDependencies(artifacts);
        return status;
    }

    private MavenProject buildProjectFromArtifact(Artifact artifact) throws MojoExecutionException {
        try {
            return this.projectBuilder.build(artifact, this.session.getProjectBuildingRequest()).getProject();
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void addParentArtifacts(MavenProject project, Set<Artifact> artifacts) throws MojoExecutionException {
        while (project.hasParent() && !artifacts.contains((project = project.getParent()).getArtifact())) {
            try {
                ProjectBuildingRequest buildingRequest = this.newResolveArtifactProjectBuildingRequest();
                Artifact resolvedArtifact = this.artifactResolver.resolveArtifact(buildingRequest, project.getArtifact()).getArtifact();
                artifacts.add(resolvedArtifact);
            }
            catch (ArtifactResolverException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }
}

