/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.dependencies;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

class Resolver {
    private Log log;
    private List<RemoteRepository> remoteRepositories;
    private RepositorySystemSession repoSession;
    private RepositorySystem repoSystem;

    Resolver(RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepositories, Log log) {
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
        this.remoteRepositories = remoteRepositories;
        this.log = log;
    }

    DefaultArtifact translate(org.apache.maven.artifact.Artifact artifact) {
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion());
    }

    String resolve(org.apache.maven.artifact.Artifact artifact) {
        String result;
        try {
            result = this.resolve(this.translate(artifact)).getAbsolutePath();
        }
        catch (ArtifactResolutionException e) {
            this.getLog().warn((CharSequence)("Cannot resolve to artifact, ignoring: " + String.valueOf(artifact)));
            result = "";
        }
        return result;
    }

    File resolve(DefaultArtifact artifact) throws ArtifactResolutionException {
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((Artifact)artifact);
        request.setRepositories(this.remoteRepositories);
        ArtifactResult result = this.repoSystem.resolveArtifact(this.repoSession, request);
        return result.getArtifact().getFile();
    }

    String resolve(List<org.apache.maven.artifact.Artifact> artifacts) {
        return null == artifacts ? "" : artifacts.stream().map(a -> this.resolve((org.apache.maven.artifact.Artifact)a)).filter(p -> p != null).collect(Collectors.joining(":", ":", ""));
    }

    File resolveSpringBootLoader(MavenProject project) {
        File result = null;
        Object springVersion = project.getProperties().get("org.springframework.boot.version");
        if (null != springVersion) {
            DefaultArtifact art = new DefaultArtifact("org.springframework.boot", "spring-boot-loader", "jar", springVersion.toString());
            try {
                result = this.resolve(art);
            }
            catch (ArtifactResolutionException e) {
                this.getLog().error((CharSequence)("Cannot resolve: " + e.getMessage()));
            }
        } else {
            this.getLog().error((CharSequence)"Cannot find spring version!");
        }
        return result;
    }

    private Log getLog() {
        return this.log;
    }
}

