/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.basicReg;

import de.iip_ecosphere.platform.deviceMgt.DeviceDescriptor;
import de.iip_ecosphere.platform.deviceMgt.basicReg.BasicDeviceRegistry;
import de.iip_ecosphere.platform.deviceMgt.basicReg.BasicRegistryDeviceDescriptor;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicDeviceRegistryTest {
    public static final String AN_IP = "AN_IP";
    public static final String ANOTHER_IP = "ANOTHER_IP";
    public static final String ANOTHER_DEVICE = "ANOTHER_DEVICE";
    private static final String A_DEVICE = "A_DEVICE";
    private BasicDeviceRegistry deviceRegistry;

    @Before
    public void setUp() {
        this.deviceRegistry = new BasicDeviceRegistry();
    }

    @Test
    public void getIds_withTwoDevices_shouldReturnListWithTwoIds() {
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
        this.deviceRegistry.addDevice(A_DEVICE, AN_IP);
        this.deviceRegistry.addDevice(ANOTHER_DEVICE, ANOTHER_IP);
        Set ids = this.deviceRegistry.getIds();
        Assert.assertEquals((long)2L, (long)ids.size());
        Assert.assertTrue((boolean)ids.contains(A_DEVICE));
        Assert.assertTrue((boolean)ids.contains(ANOTHER_DEVICE));
        this.deviceRegistry.removeDevice(A_DEVICE);
        this.deviceRegistry.removeDevice(ANOTHER_DEVICE);
    }

    @Test
    public void getManagedIds_withTwoDevices_shouldReturnListWithTwoIds() {
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
        this.deviceRegistry.addDevice(A_DEVICE, AN_IP);
        this.deviceRegistry.addDevice(ANOTHER_DEVICE, ANOTHER_IP);
        Set ids = this.deviceRegistry.getManagedIds();
        Assert.assertEquals((long)2L, (long)ids.size());
        Assert.assertTrue((boolean)ids.contains(A_DEVICE));
        Assert.assertTrue((boolean)ids.contains(ANOTHER_DEVICE));
        this.deviceRegistry.removeDevice(A_DEVICE);
        this.deviceRegistry.removeDevice(ANOTHER_DEVICE);
    }

    @Test
    public void getDevices_withTwoDevices_shouldReturnListWithTwoIds() {
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
        this.deviceRegistry.addDevice(A_DEVICE, AN_IP);
        this.deviceRegistry.addDevice(ANOTHER_DEVICE, ANOTHER_IP);
        Collection actualDevices = this.deviceRegistry.getDevices();
        Assert.assertEquals((long)2L, (long)actualDevices.size());
        Assert.assertEquals((long)1L, (long)actualDevices.stream().filter(d -> d.getId().equals(A_DEVICE)).count());
        Assert.assertEquals((long)1L, (long)actualDevices.stream().filter(d -> d.getId().equals(ANOTHER_DEVICE)).count());
        this.deviceRegistry.removeDevice(A_DEVICE);
        this.deviceRegistry.removeDevice(ANOTHER_DEVICE);
    }

    @Test
    public void getDevice_withValidId_returnsDevice() {
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
        this.deviceRegistry.addDevice(A_DEVICE, AN_IP);
        BasicRegistryDeviceDescriptor desc = this.deviceRegistry.getDevice(A_DEVICE);
        Assert.assertNotNull((Object)desc);
        desc = this.deviceRegistry.getDevice(A_DEVICE);
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((Object)A_DEVICE, (Object)desc.getId());
        Assert.assertEquals((Object)AN_IP, (Object)desc.getIp());
        Assert.assertEquals((Object)A_DEVICE, (Object)desc.getManagedId());
        Assert.assertEquals((Object)A_DEVICE, (Object)desc.getResourceId());
        this.deviceRegistry.removeDevice(A_DEVICE);
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
    }

    @Test
    public void getDevice_withInvalidId_returnsNull() {
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
        BasicRegistryDeviceDescriptor desc = this.deviceRegistry.getDevice(A_DEVICE);
        Assert.assertNull((Object)desc);
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
    }

    @Test
    public void getDeviceByManagedId_withValidId_returnsDevice() {
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
        this.deviceRegistry.addDevice(A_DEVICE, AN_IP);
        BasicRegistryDeviceDescriptor desc = this.deviceRegistry.getDevice(A_DEVICE);
        Assert.assertNotNull((Object)desc);
        desc = this.deviceRegistry.getDeviceByManagedId(A_DEVICE);
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((Object)A_DEVICE, (Object)desc.getId());
        Assert.assertEquals((Object)AN_IP, (Object)desc.getIp());
        Assert.assertEquals((Object)A_DEVICE, (Object)desc.getManagedId());
        Assert.assertEquals((Object)A_DEVICE, (Object)desc.getResourceId());
        this.deviceRegistry.removeDevice(A_DEVICE);
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
    }

    @Test
    public void getDeviceByManagedId_withInvalidId_returnsNull() {
        String uuid = UUID.randomUUID().toString();
        BasicRegistryDeviceDescriptor desc = this.deviceRegistry.getDeviceByManagedId(uuid);
        Assert.assertNull((Object)desc);
    }

    @Test
    public void addDevice_withNoIp_wontAddDevice() {
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
        this.deviceRegistry.addDevice(A_DEVICE, null);
        this.deviceRegistry.addDevice(A_DEVICE, "");
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
    }

    @Test
    public void addDevice_withNoDeviceIdentifier_wontAddDevice() {
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
        this.deviceRegistry.addDevice(null, AN_IP);
        this.deviceRegistry.addDevice("", AN_IP);
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
    }

    @Test
    public void addDevice_withAlreadyRegisteredDevice_updatesDevice() {
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
        this.deviceRegistry.addDevice(A_DEVICE, AN_IP);
        this.deviceRegistry.addDevice(A_DEVICE, ANOTHER_IP);
        BasicRegistryDeviceDescriptor desc = this.deviceRegistry.getDevice(A_DEVICE);
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((Object)A_DEVICE, (Object)desc.getId());
        Assert.assertEquals((Object)ANOTHER_IP, (Object)desc.getIp());
        Assert.assertEquals((Object)A_DEVICE, (Object)desc.getManagedId());
        Assert.assertEquals((Object)A_DEVICE, (Object)desc.getResourceId());
        this.deviceRegistry.removeDevice(A_DEVICE);
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
    }

    @Test
    public void removeDevice_withValidDevice_addRemovesDevice() {
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
        this.deviceRegistry.addDevice(A_DEVICE, AN_IP);
        BasicRegistryDeviceDescriptor desc = this.deviceRegistry.getDevice(A_DEVICE);
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((Object)desc.getId(), (Object)A_DEVICE);
        Assert.assertEquals((Object)desc.getIp(), (Object)AN_IP);
        Assert.assertEquals((Object)desc.getManagedId(), (Object)A_DEVICE);
        Assert.assertEquals((Object)desc.getResourceId(), (Object)A_DEVICE);
        this.deviceRegistry.removeDevice(A_DEVICE);
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
    }

    @Test
    public void removeDevice_withNoDevice_wontRemoveDevice() {
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
        this.deviceRegistry.addDevice(A_DEVICE, AN_IP);
        this.deviceRegistry.removeDevice("");
        this.deviceRegistry.removeDevice(null);
        this.deviceRegistry.removeDevice(ANOTHER_DEVICE);
        Assert.assertNotNull((Object)this.deviceRegistry.getDevice(A_DEVICE));
        this.deviceRegistry.removeDevice(A_DEVICE);
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
    }

    @Test
    public void sendTelemetry_withValidData_shouldSaveTelemetry() throws ExecutionException, IOException {
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
        this.deviceRegistry.addDevice(A_DEVICE, AN_IP);
        BasicRegistryDeviceDescriptor desc = this.deviceRegistry.getDevice(A_DEVICE);
        Assert.assertNotNull((Object)desc);
        DeviceDescriptor.State before = desc.getState();
        Assert.assertNotNull((Object)before);
        this.deviceRegistry.sendTelemetry(A_DEVICE, "{\"telemetryKey\": \"telemetryValue\"}");
        Assert.assertEquals((Object)before, (Object)desc.getState());
        this.deviceRegistry.removeDevice(A_DEVICE);
    }

    @Test
    public void imAlive_sendImAliveAsTelemetry() throws IOException, ExecutionException {
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
        this.deviceRegistry.addDevice(A_DEVICE, AN_IP);
        this.deviceRegistry.sendTelemetry(A_DEVICE, "{\"active\": true}");
        BasicRegistryDeviceDescriptor desc = this.deviceRegistry.getDevice(A_DEVICE);
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((Object)DeviceDescriptor.State.AVAILABLE, (Object)desc.getState());
        this.deviceRegistry.removeDevice(A_DEVICE);
    }

    @Test
    public void imAlive_withUnknownDevice_shouldNotSendImAliveAsTelemetry() throws IOException, ExecutionException {
        Assert.assertTrue((boolean)this.deviceRegistry.getIds().isEmpty());
        this.deviceRegistry.addDevice(A_DEVICE, AN_IP);
        this.deviceRegistry.imAlive(A_DEVICE);
        BasicRegistryDeviceDescriptor desc = this.deviceRegistry.getDevice(A_DEVICE);
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((Object)DeviceDescriptor.State.AVAILABLE, (Object)desc.getState());
        this.deviceRegistry.removeDevice(A_DEVICE);
    }
}

