/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.ErrorCollector;
import com.squareup.wire.schema.Loader;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/squareup/wire/schema/CoreLoader;", "Lcom/squareup/wire/schema/Loader;", "()V", "ANY_PROTO", "", "DESCRIPTOR_PROTO", "DURATION_PROTO", "EMPTY_PROTO", "STRUCT_PROTO", "TIMESTAMP_PROTO", "WIRE_EXTENSIONS_PROTO", "WIRE_RUNTIME_JAR", "WRAPPERS_PROTO", "isWireRuntimeProto", "", "location", "Lcom/squareup/wire/schema/Location;", "path", "load", "Lcom/squareup/wire/schema/ProtoFile;", "withErrors", "errors", "Lcom/squareup/wire/schema/ErrorCollector;", "wire-schema"})
public final class CoreLoader
implements Loader {
    private static final String ANY_PROTO = "google/protobuf/any.proto";
    private static final String DESCRIPTOR_PROTO = "google/protobuf/descriptor.proto";
    private static final String DURATION_PROTO = "google/protobuf/duration.proto";
    private static final String EMPTY_PROTO = "google/protobuf/empty.proto";
    private static final String STRUCT_PROTO = "google/protobuf/struct.proto";
    private static final String TIMESTAMP_PROTO = "google/protobuf/timestamp.proto";
    private static final String WRAPPERS_PROTO = "google/protobuf/wrappers.proto";
    private static final String WIRE_EXTENSIONS_PROTO = "wire/extensions.proto";
    @NotNull
    public static final String WIRE_RUNTIME_JAR = "wire-runtime.jar";
    public static final CoreLoader INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ProtoFile load(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.isWireRuntimeProto(path)) {
            InputStream resourceAsStream;
            InputStream inputStream = resourceAsStream = CoreLoader.class.getResourceAsStream('/' + path);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"resourceAsStream");
            Closeable closeable = (Closeable)Okio.buffer((Source)Okio.source((InputStream)inputStream));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BufferedSource source = (BufferedSource)closeable;
                boolean bl3 = false;
                String data = source.readUtf8();
                Location location = Location.Companion.get(path);
                ProtoFileElement element = ProtoParser.Companion.parse(location, data);
                ProtoFile protoFile = ProtoFile.Companion.get(element);
                return protoFile;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        String string = "unexpected load: " + path;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    public final boolean isWireRuntimeProto(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return Intrinsics.areEqual((Object)location.getBase(), (Object)WIRE_RUNTIME_JAR) && this.isWireRuntimeProto(location.getPath());
    }

    public final boolean isWireRuntimeProto(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Intrinsics.areEqual((Object)path, (Object)ANY_PROTO) || Intrinsics.areEqual((Object)path, (Object)DESCRIPTOR_PROTO) || Intrinsics.areEqual((Object)path, (Object)DURATION_PROTO) || Intrinsics.areEqual((Object)path, (Object)EMPTY_PROTO) || Intrinsics.areEqual((Object)path, (Object)STRUCT_PROTO) || Intrinsics.areEqual((Object)path, (Object)TIMESTAMP_PROTO) || Intrinsics.areEqual((Object)path, (Object)WRAPPERS_PROTO) || Intrinsics.areEqual((Object)path, (Object)WIRE_EXTENSIONS_PROTO);
    }

    @Override
    @NotNull
    public CoreLoader withErrors(@NotNull ErrorCollector errors) {
        Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
        return this;
    }

    private CoreLoader() {
    }

    static {
        CoreLoader coreLoader;
        INSTANCE = coreLoader = new CoreLoader();
    }
}

