/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.alarm;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.thingsboard.server.common.data.alarm.AlarmStatus;

public enum AlarmSearchStatus {
    ANY(AlarmStatus.values()),
    ACTIVE(AlarmStatus.ACTIVE_ACK, AlarmStatus.ACTIVE_UNACK),
    CLEARED(AlarmStatus.CLEARED_ACK, AlarmStatus.CLEARED_UNACK),
    ACK(AlarmStatus.ACTIVE_ACK, AlarmStatus.CLEARED_ACK),
    UNACK(AlarmStatus.ACTIVE_UNACK, AlarmStatus.CLEARED_UNACK);

    @JsonIgnore
    private Set<AlarmStatus> statuses;

    private AlarmSearchStatus(AlarmStatus ... statuses) {
        this.statuses = new LinkedHashSet<AlarmStatus>(Arrays.asList(statuses));
    }

    public Set<AlarmStatus> getStatuses() {
        return this.statuses;
    }
}

