/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.oauth2;

import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.oauth2.TenantNameStrategyType;

public class OAuth2BasicMapperConfig {
    private final String emailAttributeKey;
    private final String firstNameAttributeKey;
    private final String lastNameAttributeKey;
    private final TenantNameStrategyType tenantNameStrategy;
    private final String tenantNamePattern;
    private final String customerNamePattern;
    private final String defaultDashboardName;
    private final boolean alwaysFullScreen;

    @ConstructorProperties(value={"emailAttributeKey", "firstNameAttributeKey", "lastNameAttributeKey", "tenantNameStrategy", "tenantNamePattern", "customerNamePattern", "defaultDashboardName", "alwaysFullScreen"})
    OAuth2BasicMapperConfig(String emailAttributeKey, String firstNameAttributeKey, String lastNameAttributeKey, TenantNameStrategyType tenantNameStrategy, String tenantNamePattern, String customerNamePattern, String defaultDashboardName, boolean alwaysFullScreen) {
        this.emailAttributeKey = emailAttributeKey;
        this.firstNameAttributeKey = firstNameAttributeKey;
        this.lastNameAttributeKey = lastNameAttributeKey;
        this.tenantNameStrategy = tenantNameStrategy;
        this.tenantNamePattern = tenantNamePattern;
        this.customerNamePattern = customerNamePattern;
        this.defaultDashboardName = defaultDashboardName;
        this.alwaysFullScreen = alwaysFullScreen;
    }

    public static OAuth2BasicMapperConfigBuilder builder() {
        return new OAuth2BasicMapperConfigBuilder();
    }

    public OAuth2BasicMapperConfigBuilder toBuilder() {
        return new OAuth2BasicMapperConfigBuilder().emailAttributeKey(this.emailAttributeKey).firstNameAttributeKey(this.firstNameAttributeKey).lastNameAttributeKey(this.lastNameAttributeKey).tenantNameStrategy(this.tenantNameStrategy).tenantNamePattern(this.tenantNamePattern).customerNamePattern(this.customerNamePattern).defaultDashboardName(this.defaultDashboardName).alwaysFullScreen(this.alwaysFullScreen);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2BasicMapperConfig)) {
            return false;
        }
        OAuth2BasicMapperConfig other = (OAuth2BasicMapperConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAlwaysFullScreen() != other.isAlwaysFullScreen()) {
            return false;
        }
        String this$emailAttributeKey = this.getEmailAttributeKey();
        String other$emailAttributeKey = other.getEmailAttributeKey();
        if (this$emailAttributeKey == null ? other$emailAttributeKey != null : !this$emailAttributeKey.equals(other$emailAttributeKey)) {
            return false;
        }
        String this$firstNameAttributeKey = this.getFirstNameAttributeKey();
        String other$firstNameAttributeKey = other.getFirstNameAttributeKey();
        if (this$firstNameAttributeKey == null ? other$firstNameAttributeKey != null : !this$firstNameAttributeKey.equals(other$firstNameAttributeKey)) {
            return false;
        }
        String this$lastNameAttributeKey = this.getLastNameAttributeKey();
        String other$lastNameAttributeKey = other.getLastNameAttributeKey();
        if (this$lastNameAttributeKey == null ? other$lastNameAttributeKey != null : !this$lastNameAttributeKey.equals(other$lastNameAttributeKey)) {
            return false;
        }
        TenantNameStrategyType this$tenantNameStrategy = this.getTenantNameStrategy();
        TenantNameStrategyType other$tenantNameStrategy = other.getTenantNameStrategy();
        if (this$tenantNameStrategy == null ? other$tenantNameStrategy != null : !((Object)((Object)this$tenantNameStrategy)).equals((Object)other$tenantNameStrategy)) {
            return false;
        }
        String this$tenantNamePattern = this.getTenantNamePattern();
        String other$tenantNamePattern = other.getTenantNamePattern();
        if (this$tenantNamePattern == null ? other$tenantNamePattern != null : !this$tenantNamePattern.equals(other$tenantNamePattern)) {
            return false;
        }
        String this$customerNamePattern = this.getCustomerNamePattern();
        String other$customerNamePattern = other.getCustomerNamePattern();
        if (this$customerNamePattern == null ? other$customerNamePattern != null : !this$customerNamePattern.equals(other$customerNamePattern)) {
            return false;
        }
        String this$defaultDashboardName = this.getDefaultDashboardName();
        String other$defaultDashboardName = other.getDefaultDashboardName();
        return !(this$defaultDashboardName == null ? other$defaultDashboardName != null : !this$defaultDashboardName.equals(other$defaultDashboardName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuth2BasicMapperConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAlwaysFullScreen() ? 79 : 97);
        String $emailAttributeKey = this.getEmailAttributeKey();
        result = result * 59 + ($emailAttributeKey == null ? 43 : $emailAttributeKey.hashCode());
        String $firstNameAttributeKey = this.getFirstNameAttributeKey();
        result = result * 59 + ($firstNameAttributeKey == null ? 43 : $firstNameAttributeKey.hashCode());
        String $lastNameAttributeKey = this.getLastNameAttributeKey();
        result = result * 59 + ($lastNameAttributeKey == null ? 43 : $lastNameAttributeKey.hashCode());
        TenantNameStrategyType $tenantNameStrategy = this.getTenantNameStrategy();
        result = result * 59 + ($tenantNameStrategy == null ? 43 : ((Object)((Object)$tenantNameStrategy)).hashCode());
        String $tenantNamePattern = this.getTenantNamePattern();
        result = result * 59 + ($tenantNamePattern == null ? 43 : $tenantNamePattern.hashCode());
        String $customerNamePattern = this.getCustomerNamePattern();
        result = result * 59 + ($customerNamePattern == null ? 43 : $customerNamePattern.hashCode());
        String $defaultDashboardName = this.getDefaultDashboardName();
        result = result * 59 + ($defaultDashboardName == null ? 43 : $defaultDashboardName.hashCode());
        return result;
    }

    public String getEmailAttributeKey() {
        return this.emailAttributeKey;
    }

    public String getFirstNameAttributeKey() {
        return this.firstNameAttributeKey;
    }

    public String getLastNameAttributeKey() {
        return this.lastNameAttributeKey;
    }

    public TenantNameStrategyType getTenantNameStrategy() {
        return this.tenantNameStrategy;
    }

    public String getTenantNamePattern() {
        return this.tenantNamePattern;
    }

    public String getCustomerNamePattern() {
        return this.customerNamePattern;
    }

    public String getDefaultDashboardName() {
        return this.defaultDashboardName;
    }

    public boolean isAlwaysFullScreen() {
        return this.alwaysFullScreen;
    }

    public String toString() {
        return "OAuth2BasicMapperConfig(emailAttributeKey=" + this.getEmailAttributeKey() + ", firstNameAttributeKey=" + this.getFirstNameAttributeKey() + ", lastNameAttributeKey=" + this.getLastNameAttributeKey() + ", tenantNameStrategy=" + this.getTenantNameStrategy() + ", tenantNamePattern=" + this.getTenantNamePattern() + ", customerNamePattern=" + this.getCustomerNamePattern() + ", defaultDashboardName=" + this.getDefaultDashboardName() + ", alwaysFullScreen=" + this.isAlwaysFullScreen() + ")";
    }

    public static class OAuth2BasicMapperConfigBuilder {
        private String emailAttributeKey;
        private String firstNameAttributeKey;
        private String lastNameAttributeKey;
        private TenantNameStrategyType tenantNameStrategy;
        private String tenantNamePattern;
        private String customerNamePattern;
        private String defaultDashboardName;
        private boolean alwaysFullScreen;

        OAuth2BasicMapperConfigBuilder() {
        }

        public OAuth2BasicMapperConfigBuilder emailAttributeKey(String emailAttributeKey) {
            this.emailAttributeKey = emailAttributeKey;
            return this;
        }

        public OAuth2BasicMapperConfigBuilder firstNameAttributeKey(String firstNameAttributeKey) {
            this.firstNameAttributeKey = firstNameAttributeKey;
            return this;
        }

        public OAuth2BasicMapperConfigBuilder lastNameAttributeKey(String lastNameAttributeKey) {
            this.lastNameAttributeKey = lastNameAttributeKey;
            return this;
        }

        public OAuth2BasicMapperConfigBuilder tenantNameStrategy(TenantNameStrategyType tenantNameStrategy) {
            this.tenantNameStrategy = tenantNameStrategy;
            return this;
        }

        public OAuth2BasicMapperConfigBuilder tenantNamePattern(String tenantNamePattern) {
            this.tenantNamePattern = tenantNamePattern;
            return this;
        }

        public OAuth2BasicMapperConfigBuilder customerNamePattern(String customerNamePattern) {
            this.customerNamePattern = customerNamePattern;
            return this;
        }

        public OAuth2BasicMapperConfigBuilder defaultDashboardName(String defaultDashboardName) {
            this.defaultDashboardName = defaultDashboardName;
            return this;
        }

        public OAuth2BasicMapperConfigBuilder alwaysFullScreen(boolean alwaysFullScreen) {
            this.alwaysFullScreen = alwaysFullScreen;
            return this;
        }

        public OAuth2BasicMapperConfig build() {
            return new OAuth2BasicMapperConfig(this.emailAttributeKey, this.firstNameAttributeKey, this.lastNameAttributeKey, this.tenantNameStrategy, this.tenantNamePattern, this.customerNamePattern, this.defaultDashboardName, this.alwaysFullScreen);
        }

        public String toString() {
            return "OAuth2BasicMapperConfig.OAuth2BasicMapperConfigBuilder(emailAttributeKey=" + this.emailAttributeKey + ", firstNameAttributeKey=" + this.firstNameAttributeKey + ", lastNameAttributeKey=" + this.lastNameAttributeKey + ", tenantNameStrategy=" + this.tenantNameStrategy + ", tenantNamePattern=" + this.tenantNamePattern + ", customerNamePattern=" + this.customerNamePattern + ", defaultDashboardName=" + this.defaultDashboardName + ", alwaysFullScreen=" + this.alwaysFullScreen + ")";
        }
    }
}

