/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.query;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import org.thingsboard.server.common.data.query.DynamicValueSourceType;
import org.thingsboard.server.common.data.validation.NoXss;

public class DynamicValue<T>
implements Serializable {
    @JsonIgnore
    private T resolvedValue;
    private final DynamicValueSourceType sourceType;
    @NoXss
    private final String sourceAttribute;
    private final boolean inherit;

    public DynamicValue(DynamicValueSourceType sourceType, String sourceAttribute) {
        this.sourceAttribute = sourceAttribute;
        this.sourceType = sourceType;
        this.inherit = false;
    }

    public T getResolvedValue() {
        return this.resolvedValue;
    }

    public DynamicValueSourceType getSourceType() {
        return this.sourceType;
    }

    public String getSourceAttribute() {
        return this.sourceAttribute;
    }

    public boolean isInherit() {
        return this.inherit;
    }

    @JsonIgnore
    public void setResolvedValue(T resolvedValue) {
        this.resolvedValue = resolvedValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicValue)) {
            return false;
        }
        DynamicValue other = (DynamicValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isInherit() != other.isInherit()) {
            return false;
        }
        T this$resolvedValue = this.getResolvedValue();
        T other$resolvedValue = other.getResolvedValue();
        if (this$resolvedValue == null ? other$resolvedValue != null : !this$resolvedValue.equals(other$resolvedValue)) {
            return false;
        }
        DynamicValueSourceType this$sourceType = this.getSourceType();
        DynamicValueSourceType other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !((Object)((Object)this$sourceType)).equals((Object)other$sourceType)) {
            return false;
        }
        String this$sourceAttribute = this.getSourceAttribute();
        String other$sourceAttribute = other.getSourceAttribute();
        return !(this$sourceAttribute == null ? other$sourceAttribute != null : !this$sourceAttribute.equals(other$sourceAttribute));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isInherit() ? 79 : 97);
        T $resolvedValue = this.getResolvedValue();
        result = result * 59 + ($resolvedValue == null ? 43 : $resolvedValue.hashCode());
        DynamicValueSourceType $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : ((Object)((Object)$sourceType)).hashCode());
        String $sourceAttribute = this.getSourceAttribute();
        result = result * 59 + ($sourceAttribute == null ? 43 : $sourceAttribute.hashCode());
        return result;
    }

    public String toString() {
        return "DynamicValue(resolvedValue=" + this.getResolvedValue() + ", sourceType=" + this.getSourceType() + ", sourceAttribute=" + this.getSourceAttribute() + ", inherit=" + this.isInherit() + ")";
    }

    @ConstructorProperties(value={"sourceType", "sourceAttribute", "inherit"})
    public DynamicValue(DynamicValueSourceType sourceType, String sourceAttribute, boolean inherit) {
        this.sourceType = sourceType;
        this.sourceAttribute = sourceAttribute;
        this.inherit = inherit;
    }
}

