/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.kv;

import java.util.Objects;
import java.util.Optional;
import org.thingsboard.server.common.data.kv.BasicKvEntry;
import org.thingsboard.server.common.data.kv.DataType;

public class DoubleDataEntry
extends BasicKvEntry {
    private final Double value;

    public DoubleDataEntry(String key, Double value) {
        super(key);
        this.value = value;
    }

    @Override
    public DataType getDataType() {
        return DataType.DOUBLE;
    }

    @Override
    public Optional<Double> getDoubleValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleDataEntry)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DoubleDataEntry that = (DoubleDataEntry)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public String toString() {
        return "DoubleDataEntry{value=" + this.value + "} " + super.toString();
    }

    @Override
    public String getValueAsString() {
        return Double.toString(this.value);
    }
}

