/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.CycleChecker;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.ErrorCollector;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.FileLinker;
import com.squareup.wire.schema.Loader;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Reserved;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SyntaxRules;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.UtilJVMKt;
import com.squareup.wire.schema.internal.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0012\u0012\u0006\u0010\t\u001a\u00020\u0000\u0012\u0006\u0010\n\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0018J\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\rH\u0000\u00a2\u0006\u0002\b#J\u0018\u0010$\u001a\u0004\u0018\u00010\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0012J\u0010\u0010'\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020\u001dJ\u0015\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020\u001dJ\u0014\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/J\b\u00101\u001a\u0004\u0018\u00010\u0012J\u000e\u00102\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u001bJ/\u00103\u001a\u0004\u0018\u0001H4\"\u0004\b\u0000\u001042\u0006\u00105\u001a\u00020\u00122\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H407\u00a2\u0006\u0002\u00108J\b\u00109\u001a\u00020\u0012H\u0002J\u000e\u0010:\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u0012J\u000e\u0010;\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u0012J\u0018\u0010;\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u0007H\u0002J\u0014\u0010=\u001a\u00020\u001f2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00180/J*\u0010?\u001a\u00020\u001f2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001b0/2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\r2\u0006\u0010C\u001a\u00020DJ\u0016\u0010E\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u0012J\u0016\u0010I\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020G2\u0006\u0010!\u001a\u00020\u001dJ\u000e\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u0001R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0015j\b\u0012\u0004\u0012\u00020\u0013`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00180\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/squareup/wire/schema/Linker;", "", "loader", "Lcom/squareup/wire/schema/Loader;", "errors", "Lcom/squareup/wire/schema/ErrorCollector;", "permitPackageCycles", "", "(Lcom/squareup/wire/schema/Loader;Lcom/squareup/wire/schema/ErrorCollector;Z)V", "enclosing", "additionalContext", "(Lcom/squareup/wire/schema/Linker;Ljava/lang/Object;)V", "contextStack", "", "getErrors", "()Lcom/squareup/wire/schema/ErrorCollector;", "fileLinkers", "", "", "Lcom/squareup/wire/schema/FileLinker;", "fileOptionsQueue", "Ljava/util/Queue;", "Lcom/squareup/wire/schema/internal/MutableQueue;", "protoTypeNames", "Lcom/squareup/wire/schema/Type;", "requestedFields", "", "Lcom/squareup/wire/schema/Field;", "requestedTypes", "Lcom/squareup/wire/schema/ProtoType;", "addType", "", "protoType", "type", "contextImportedTypes", "contextImportedTypes$wire_schema", "dereference", "self", "field", "get", "getFileLinker", "path", "getFileLinker$wire_schema", "getForOptions", "link", "Lcom/squareup/wire/schema/Schema;", "sourceProtoFiles", "", "Lcom/squareup/wire/schema/ProtoFile;", "packageName", "request", "resolve", "T", "name", "map", "", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/Object;", "resolveContext", "resolveMessageType", "resolveType", "messageOnly", "validateEnumConstantNameUniqueness", "nestedTypes", "validateFields", "fields", "reserveds", "Lcom/squareup/wire/schema/Reserved;", "syntaxRules", "Lcom/squareup/wire/schema/SyntaxRules;", "validateImportForPath", "location", "Lcom/squareup/wire/schema/Location;", "requiredImport", "validateImportForType", "withContext", "context", "wire-schema"})
public final class Linker {
    private final Loader loader;
    private final Map<String, FileLinker> fileLinkers;
    private final Queue<FileLinker> fileOptionsQueue;
    private final Map<String, Type> protoTypeNames;
    private final List<Object> contextStack;
    private final Set<ProtoType> requestedTypes;
    private final Set<Field> requestedFields;
    private final boolean permitPackageCycles;
    @NotNull
    private final ErrorCollector errors;

    @NotNull
    public final ErrorCollector getErrors() {
        return this.errors;
    }

    @NotNull
    public final FileLinker getFileLinker$wire_schema(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileLinker existing = this.fileLinkers.get(path);
        if (existing != null) {
            return existing;
        }
        ProtoFile protoFile = this.loader.withErrors(this.errors).load(path);
        FileLinker result = new FileLinker(protoFile, this.withContext(protoFile));
        this.fileLinkers.put(path, result);
        Collection collection = this.fileOptionsQueue;
        boolean bl = false;
        collection.add(result);
        return result;
    }

    @NotNull
    public final Schema link(@NotNull Iterable<ProtoFile> sourceProtoFiles) {
        Intrinsics.checkNotNullParameter(sourceProtoFiles, (String)"sourceProtoFiles");
        boolean bl = false;
        List sourceFiles = new ArrayList();
        Collection collection = sourceFiles;
        Iterator iterator = this.getFileLinker$wire_schema("google/protobuf/descriptor.proto");
        boolean bl2 = false;
        collection.add(iterator);
        for (ProtoFile sourceFile : sourceProtoFiles) {
            FileLinker fileLinker = new FileLinker(sourceFile, this.withContext(sourceFile));
            this.fileLinkers.put(sourceFile.getLocation().getPath(), fileLinker);
            Collection collection2 = sourceFiles;
            boolean bl3 = false;
            collection2.add(fileLinker);
        }
        for (Object fileLinker : sourceFiles) {
            ((FileLinker)fileLinker).requireTypesRegistered();
        }
        for (Object fileLinker : sourceFiles) {
            ((FileLinker)fileLinker).requireExtensionsLinked();
        }
        for (Object fileLinker : sourceFiles) {
            ((FileLinker)fileLinker).requireImportedExtensionsRegistered();
        }
        for (Object fileLinker : sourceFiles) {
            ((FileLinker)fileLinker).linkMembers();
        }
        for (Object fileLinker : sourceFiles) {
            SyntaxRules syntaxRules = SyntaxRules.Companion.get(((FileLinker)fileLinker).getProtoFile().getSyntax());
            ((FileLinker)fileLinker).linkOptions(syntaxRules, true);
        }
        for (Object fileLinker : sourceFiles) {
            ((FileLinker)fileLinker).requireImportedExtensionOptionsLinked(false);
        }
        while (true) {
            Object fileLinker;
            fileLinker = this.fileOptionsQueue;
            boolean bl4 = false;
            if (!(!fileLinker.isEmpty())) break;
            FileLinker fileLinker2 = this.fileOptionsQueue.poll();
            Intrinsics.checkNotNull((Object)fileLinker2);
            fileLinker = fileLinker2;
            ((FileLinker)fileLinker).requireFileOptionsLinked(false);
        }
        for (Object fileLinker : sourceFiles) {
            SyntaxRules syntaxRules = SyntaxRules.Companion.get(((FileLinker)fileLinker).getProtoFile().getSyntax());
            ((FileLinker)fileLinker).validate(syntaxRules);
        }
        CycleChecker cycleChecker = new CycleChecker(this.fileLinkers, this.errors);
        cycleChecker.checkForImportCycles();
        if (!this.permitPackageCycles) {
            cycleChecker.checkForPackageCycles();
        }
        this.errors.throwIfNonEmpty();
        boolean syntaxRules = false;
        List result = new ArrayList();
        for (FileLinker fileLinker : this.fileLinkers.values()) {
            boolean anyFieldIsUsed;
            boolean anyTypeIsUsed;
            block23: {
                boolean bl5;
                boolean bl6;
                block21: {
                    if (sourceFiles.contains(fileLinker)) {
                        result.add(fileLinker.getProtoFile());
                        continue;
                    }
                    Iterable $this$any$iv = fileLinker.getProtoFile().typesAndNestedTypes();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl6 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Type type = (Type)element$iv;
                            boolean bl7 = false;
                            if (!this.requestedTypes.contains(type.getType())) continue;
                            bl6 = true;
                            break block21;
                        }
                        bl6 = false;
                    }
                }
                anyTypeIsUsed = bl6;
                Iterable $this$any$iv = fileLinker.getProtoFile().getExtendList();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl5 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl8;
                        block22: {
                            Extend extend = (Extend)element$iv;
                            boolean bl9 = false;
                            Iterable $this$any$iv2 = extend.getFields();
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl8 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    Field it = (Field)element$iv2;
                                    boolean bl10 = false;
                                    if (!this.requestedFields.contains(it)) continue;
                                    bl8 = true;
                                    break block22;
                                }
                                bl8 = false;
                            }
                        }
                        if (!bl8) continue;
                        bl5 = true;
                        break block23;
                    }
                    bl5 = anyFieldIsUsed = false;
                }
            }
            if (!anyTypeIsUsed && !anyFieldIsUsed) continue;
            result.add(fileLinker.getProtoFile().retainLinked(CollectionsKt.toSet((Iterable)this.requestedTypes), this.requestedFields));
        }
        return new Schema(result);
    }

    @NotNull
    public final ProtoType resolveType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.resolveType(name, false);
    }

    @NotNull
    public final ProtoType resolveMessageType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.resolveType(name, true);
    }

    private final ProtoType resolveType(String name, boolean messageOnly) {
        ProtoType type = ProtoType.Companion.get(name);
        if (type.isScalar()) {
            if (messageOnly) {
                this.errors.plusAssign("expected a message but was " + name);
            }
            return type;
        }
        if (type.isMap()) {
            if (messageOnly) {
                this.errors.plusAssign("expected a message but was " + name);
            }
            ProtoType keyType = this.resolveType(String.valueOf(type.getKeyType()), false);
            ProtoType valueType = this.resolveType(String.valueOf(type.getValueType()), false);
            return ProtoType.Companion.get(keyType, valueType, name);
        }
        Type resolved = this.resolve(name, this.protoTypeNames);
        if (resolved == null) {
            for (FileLinker fileLinker : this.contextImportedTypes$wire_schema()) {
                fileLinker.requireTypesRegistered();
            }
            resolved = this.resolve(name, this.protoTypeNames);
        }
        if (resolved == null) {
            this.errors.plusAssign("unable to resolve " + name);
            return ProtoType.BYTES;
        }
        if (messageOnly && !(resolved instanceof MessageType)) {
            this.errors.plusAssign("expected a message but was " + name);
            return ProtoType.BYTES;
        }
        this.requestedTypes.add(resolved.getType());
        return resolved.getType();
    }

    @Nullable
    public final <T> T resolve(@NotNull String name, @NotNull Map<String, ? extends T> map) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        if (StringsKt.startsWith$default((String)name, (String)".", (boolean)false, (int)2, null)) {
            String string = name;
            int n = 1;
            boolean bl = false;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            T result = map.get(string2);
            if (result != null) {
                return result;
            }
        } else {
            T result;
            String prefix = this.resolveContext();
            while (true) {
                String string;
                CharSequence charSequence = prefix;
                boolean bl = false;
                if (!(charSequence.length() > 0)) break;
                result = map.get(prefix + '.' + name);
                if (result != null) {
                    return result;
                }
                int dot = StringsKt.lastIndexOf$default((CharSequence)prefix, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (dot != -1) {
                    String string3 = prefix;
                    int n = 0;
                    boolean bl2 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n, dot);
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    string = "";
                }
                prefix = string;
            }
            result = map.get(name);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final String resolveContext() {
        int n = ((Collection)this.contextStack).size();
        --n;
        boolean bl = false;
        while (n >= 0) {
            void i;
            Object context = this.contextStack.get((int)i);
            if (context instanceof Type) {
                return ((Type)context).getType().toString();
            }
            if (context instanceof ProtoFile) {
                String packageName = ((ProtoFile)context).getPackageName();
                String string = packageName;
                if (string == null) {
                    string = "";
                }
                return string;
            }
            if (context instanceof Field && ((Field)context).isExtension()) {
                String string = ((Field)context).getPackageName();
                if (string == null) {
                    string = "";
                }
                return string;
            }
            --i;
        }
        throw (Throwable)new IllegalStateException();
    }

    @Nullable
    public final String packageName() {
        for (Object context : this.contextStack) {
            if (!(context instanceof ProtoFile)) continue;
            return ((ProtoFile)context).getPackageName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FileLinker> contextImportedTypes$wire_schema() {
        int n = 0;
        List result = new ArrayList();
        n = ((Collection)this.contextStack).size();
        --n;
        boolean bl = false;
        while (n >= 0) {
            Location location;
            void i;
            Object context = this.contextStack.get((int)i);
            Location location2 = context instanceof ProtoFile ? ((ProtoFile)context).getLocation() : (location = context instanceof Field && ((Field)context).isExtension() ? ((Field)context).getLocation() : null);
            if (location != null) {
                String path = location.getPath();
                FileLinker fileLinker = this.getFileLinker$wire_schema(path);
                for (String effectiveImport : fileLinker.effectiveImports()) {
                    result.add(this.getFileLinker$wire_schema(effectiveImport));
                }
            }
            --i;
        }
        return result;
    }

    public final void addType(@NotNull ProtoType protoType, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.protoTypeNames.put(protoType.toString(), type);
    }

    @Nullable
    public final Type get(@NotNull ProtoType protoType) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        Type result = this.protoTypeNames.get(protoType.toString());
        if (result == null) {
            for (FileLinker fileLinker : this.contextImportedTypes$wire_schema()) {
                fileLinker.requireTypesRegistered();
            }
            result = this.protoTypeNames.get(protoType.toString());
        }
        if (result != null) {
            this.requestedTypes.add(protoType);
        }
        return result;
    }

    @Nullable
    public final Type getForOptions(@NotNull ProtoType protoType) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        Type type = this.get(protoType);
        if (type == null) {
            return null;
        }
        Type result = type;
        FileLinker fileLinker = this.getFileLinker$wire_schema(result.getLocation().getPath());
        fileLinker.requireMembersLinked(result);
        return result;
    }

    public final void request(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.requestedFields.add(field);
    }

    @Nullable
    public final Field dereference(@NotNull Field self, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String field2 = field;
        if (StringsKt.startsWith$default((String)field2, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)field2, (String)"]", (boolean)false, (int)2, null)) {
            String string = field2;
            int n = 1;
            int n2 = field2.length() - 1;
            boolean bl = false;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            field2 = string2;
        }
        ProtoType protoType = self.getType();
        Intrinsics.checkNotNull((Object)protoType);
        Type type = this.getForOptions(protoType);
        if (type instanceof MessageType) {
            Field messageField = ((MessageType)type).field(field2);
            if (messageField != null) {
                return messageField;
            }
            Map<String, Field> typeExtensions = ((MessageType)type).extensionFieldsMap();
            Field extensionField = this.resolve(field2, typeExtensions);
            if (extensionField != null) {
                return extensionField;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void validateFields(@NotNull Iterable<Field> fields, @NotNull List<Reserved> reserveds, @NotNull SyntaxRules syntaxRules) {
        Field field;
        int n;
        int n2;
        Object key$iv;
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter(reserveds, (String)"reserveds");
        Intrinsics.checkNotNullParameter((Object)syntaxRules, (String)"syntaxRules");
        boolean bl = false;
        LinkedHashMap tagToField = new LinkedHashMap();
        boolean bl2 = false;
        LinkedHashMap nameToField = new LinkedHashMap();
        boolean bl3 = false;
        LinkedHashMap jsonNameToField = new LinkedHashMap();
        for (Field field2 : fields) {
            Object object;
            Object object2;
            Set answer$iv;
            boolean bl4;
            int tag22 = field2.getTag();
            if (!UtilKt.isValidTag(tag22)) {
                this.errors.at(field2).plusAssign("tag is out of range: " + tag22);
            }
            for (Reserved reserved : reserveds) {
                if (reserved.matchesTag(tag22)) {
                    this.errors.at(field2).plusAssign("tag " + tag22 + " is reserved (" + reserved.getLocation() + ')');
                }
                if (!reserved.matchesName(field2.getName())) continue;
                this.errors.at(field2).plusAssign("name '" + field2.getName() + "' is reserved (" + reserved.getLocation() + ')');
            }
            Map map = tagToField;
            key$iv = tag22;
            boolean $i$f$getOrPut = false;
            Object value$iv = map.get(key$iv);
            if (value$iv == null) {
                boolean bl5 = false;
                bl4 = false;
                answer$iv = new LinkedHashSet();
                map.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            ((Set)object2).add(field2);
            Map map2 = nameToField;
            key$iv = field2.getQualifiedName();
            $i$f$getOrPut = false;
            value$iv = map2.get(key$iv);
            if (value$iv == null) {
                boolean bl6 = false;
                bl4 = false;
                answer$iv = new LinkedHashSet();
                map2.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(field2);
            if (!field2.isExtension()) {
                Object object3;
                Map map3 = jsonNameToField;
                key$iv = syntaxRules.jsonName(field2.getName(), field2.getDeclaredJsonName());
                $i$f$getOrPut = false;
                value$iv = map3.get(key$iv);
                if (value$iv == null) {
                    boolean bl7 = false;
                    bl4 = false;
                    answer$iv = new LinkedHashSet();
                    map3.put(key$iv, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                ((Set)object3).add(field2);
            }
            ProtoType protoType = field2.getType();
            Intrinsics.checkNotNull((Object)protoType);
            syntaxRules.validateTypeReference(this.get(protoType), this.errors.at(field2));
        }
        Map tag22 = tagToField;
        boolean bl5 = false;
        Object object = tag22.entrySet().iterator();
        while (object.hasNext()) {
            void key;
            Map.Entry field2 = (Map.Entry)object.next();
            key$iv = field2;
            boolean $i$f$getOrPut = false;
            int tag22 = ((Number)key$iv.getKey()).intValue();
            key$iv = field2;
            $i$f$getOrPut = false;
            Set set = (Set)key$iv.getValue();
            if (set.size() <= 1) continue;
            StringBuilder error = new StringBuilder();
            error.append("multiple fields share tag " + (int)key + ':');
            Iterable $this$forEachIndexed$iv = set;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                n2 = index$iv++;
                n = 0;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Field field3 = (Field)item$iv;
                int index = n2;
                boolean bl8 = false;
                error.append("\n  " + (index + 1) + ". " + field.getName() + " (" + field.getLocation() + ')');
            }
            String string = error.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"error.toString()");
            this.errors.plusAssign(string);
        }
        boolean hasCollidingFields = false;
        for (Set collidingFields : nameToField.values()) {
            if (collidingFields.size() <= 1) continue;
            hasCollidingFields = true;
            Field field4 = (Field)collidingFields.iterator().next();
            StringBuilder error2 = new StringBuilder();
            error2.append("multiple fields share name " + field4.getName() + ':');
            Set set = collidingFields;
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"collidingFields");
            Iterable $this$forEachIndexed$iv = set;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                n2 = index$iv++;
                n = 0;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                field = (Field)item$iv;
                int index2 = n2;
                boolean bl9 = false;
                error2.append("\n  " + (index2 + 1) + ". " + field.getName() + " (" + field.getLocation() + ')');
            }
            String string = error2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"error.toString()");
            this.errors.plusAssign(string);
        }
        if (!hasCollidingFields) {
            Map map = jsonNameToField;
            boolean error2 = false;
            Iterator<Object> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Object $this$forEachIndexed$iv = object = (Map.Entry)iterator.next();
                boolean $i$f$forEachIndexed = false;
                String string = (String)$this$forEachIndexed$iv.getKey();
                $this$forEachIndexed$iv = object;
                $i$f$forEachIndexed = false;
                Set fields2 = (Set)$this$forEachIndexed$iv.getValue();
                if (fields2.size() <= 1) continue;
                StringBuilder error3 = new StringBuilder();
                error3.append("multiple fields share same JSON name '" + string + "':");
                Iterable $this$forEachIndexed$iv2 = fields2;
                boolean $i$f$forEachIndexed2 = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv2) {
                    void field4;
                    n = index$iv++;
                    boolean bl6 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Field index2 = (Field)item$iv;
                    int index3 = n;
                    boolean bl11 = false;
                    error3.append("\n  " + (index3 + 1) + ". " + field4.getName() + " (" + field4.getLocation() + ')');
                }
                String string2 = error3.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"error.toString()");
                this.errors.plusAssign(string2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void validateEnumConstantNameUniqueness(@NotNull Iterable<? extends Type> nestedTypes) {
        boolean bl;
        Map.Entry<String, Set> $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(nestedTypes, (String)"nestedTypes");
        boolean bl2 = false;
        Map nameToType = new LinkedHashMap();
        for (Type type : nestedTypes) {
            if (!(type instanceof EnumType)) continue;
            for (EnumConstant enumConstant : ((EnumType)type).getConstants()) {
                Object object;
                Map map = nameToType;
                String key$iv = enumConstant.getName();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                $this$getOrPut$iv = object;
                bl = false;
                boolean stringBuilder = false;
                Set it = (Set)((Object)$this$getOrPut$iv);
                boolean bl6 = false;
                Collection collection = it;
                Type type2 = type;
                boolean bl5 = false;
                collection.add(type2);
            }
        }
        Map map = nameToType;
        boolean bl6 = false;
        for (Map.Entry entry : map.entrySet()) {
            String error;
            $this$getOrPut$iv = entry;
            bl = false;
            String string = (String)$this$getOrPut$iv.getKey();
            $this$getOrPut$iv = entry;
            bl = false;
            Set values = (Set)$this$getOrPut$iv.getValue();
            if (values.size() <= 1) continue;
            bl = false;
            boolean bl7 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl8 = false;
            boolean bl9 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl12 = false;
            $this$buildString.append("multiple enums share constant " + string + ':');
            Iterable $this$forEachIndexed$iv = values;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void enumType;
                int n = index$iv++;
                boolean bl10 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                EnumType enumType2 = (EnumType)item$iv;
                int index = n;
                boolean bl14 = false;
                StringBuilder stringBuilder2 = new StringBuilder().append("\n  ").append(index + 1).append(". ").append(enumType.getType()).append('.').append(string).append(' ').append('(');
                EnumConstant enumConstant = enumType.constant(string);
                Intrinsics.checkNotNull((Object)enumConstant);
                $this$buildString.append(stringBuilder2.append(enumConstant.getLocation()).append(')').toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            this.errors.plusAssign(error);
        }
    }

    public final void validateImportForType(@NotNull Location location, @NotNull ProtoType type) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ProtoType type2 = type;
        if (type2.isMap()) {
            ProtoType protoType = type2.getValueType();
            Intrinsics.checkNotNull((Object)protoType);
            type2 = protoType;
        }
        if (type2.isScalar()) {
            return;
        }
        String path = location.getPath();
        Type type3 = this.get(type2);
        Intrinsics.checkNotNull((Object)type3);
        String requiredImport = type3.getLocation().getPath();
        FileLinker fileLinker = this.getFileLinker$wire_schema(path);
        if (Intrinsics.areEqual((Object)path, (Object)requiredImport) ^ true && !fileLinker.effectiveImports().contains(requiredImport)) {
            this.errors.plusAssign(path + " needs to import " + requiredImport);
        }
    }

    public final void validateImportForPath(@NotNull Location location, @NotNull String requiredImport) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)requiredImport, (String)"requiredImport");
        String path = location.getPath();
        FileLinker fileLinker = this.getFileLinker$wire_schema(path);
        if (Intrinsics.areEqual((Object)path, (Object)requiredImport) ^ true && !fileLinker.effectiveImports().contains(requiredImport)) {
            this.errors.plusAssign(path + " needs to import " + requiredImport);
        }
    }

    @NotNull
    public final Linker withContext(@NotNull Object context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Linker(this, context);
    }

    public Linker(@NotNull Loader loader, @NotNull ErrorCollector errors, boolean permitPackageCycles) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
        this.loader = loader;
        boolean bl = false;
        this.fileLinkers = new LinkedHashMap();
        this.fileOptionsQueue = UtilJVMKt.mutableQueueOf();
        bl = false;
        this.protoTypeNames = new LinkedHashMap();
        this.contextStack = CollectionsKt.emptyList();
        bl = false;
        this.requestedTypes = new LinkedHashSet();
        bl = false;
        this.requestedFields = new LinkedHashSet();
        this.errors = errors;
        this.permitPackageCycles = permitPackageCycles;
    }

    private Linker(Linker enclosing, Object additionalContext) {
        this.loader = enclosing.loader;
        this.fileLinkers = enclosing.fileLinkers;
        this.fileOptionsQueue = enclosing.fileOptionsQueue;
        this.protoTypeNames = enclosing.protoTypeNames;
        this.contextStack = CollectionsKt.plus((Collection)enclosing.contextStack, (Object)additionalContext);
        this.requestedTypes = enclosing.requestedTypes;
        this.requestedFields = enclosing.requestedFields;
        this.errors = enclosing.errors.at(additionalContext);
        this.permitPackageCycles = false;
    }
}

