/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Arrays;

public class JacksonUtil {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        try {
            return (T)(fromValue != null ? OBJECT_MAPPER.convertValue(fromValue, toValueType) : null);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The given object value: " + fromValue + " cannot be converted to " + toValueType, e);
        }
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        try {
            return (T)(fromValue != null ? OBJECT_MAPPER.convertValue(fromValue, toValueTypeRef) : null);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The given object value: " + fromValue + " cannot be converted to " + toValueTypeRef, e);
        }
    }

    public static <T> T fromString(String string, Class<T> clazz) {
        try {
            return (T)(string != null ? OBJECT_MAPPER.readValue(string, clazz) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given string value: " + string + " cannot be transformed to Json object", e);
        }
    }

    public static <T> T fromString(String string, TypeReference<T> valueTypeRef) {
        try {
            return (T)(string != null ? OBJECT_MAPPER.readValue(string, valueTypeRef) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given string value: " + string + " cannot be transformed to Json object", e);
        }
    }

    public static <T> T fromBytes(byte[] bytes, Class<T> clazz) {
        try {
            return (T)(bytes != null ? OBJECT_MAPPER.readValue(bytes, clazz) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given string value: " + Arrays.toString(bytes) + " cannot be transformed to Json object", e);
        }
    }

    public static JsonNode fromBytes(byte[] bytes) {
        try {
            return OBJECT_MAPPER.readTree(bytes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given byte[] value: " + Arrays.toString(bytes) + " cannot be transformed to Json object", e);
        }
    }

    public static String toString(Object value) {
        try {
            return value != null ? OBJECT_MAPPER.writeValueAsString(value) : null;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("The given Json object value: " + value + " cannot be transformed to a String", e);
        }
    }

    public static JsonNode toJsonNode(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return OBJECT_MAPPER.readTree(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ObjectNode newObjectNode() {
        return OBJECT_MAPPER.createObjectNode();
    }

    public static <T> T clone(T value) {
        Class<?> valueClass = value.getClass();
        return (T)JacksonUtil.fromString(JacksonUtil.toString(value), valueClass);
    }

    public static <T> JsonNode valueToTree(T value) {
        return OBJECT_MAPPER.valueToTree(value);
    }
}

