/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.device;

import java.util.Collections;
import java.util.List;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.relation.EntityRelationsQuery;
import org.thingsboard.server.common.data.relation.RelationEntityTypeFilter;
import org.thingsboard.server.common.data.relation.RelationsSearchParameters;

public class DeviceSearchQuery {
    private RelationsSearchParameters parameters;
    private String relationType;
    private List<String> deviceTypes;

    public EntityRelationsQuery toEntitySearchQuery() {
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(this.parameters);
        query.setFilters(Collections.singletonList(new RelationEntityTypeFilter(this.relationType == null ? "Contains" : this.relationType, Collections.singletonList(EntityType.DEVICE))));
        return query;
    }

    public RelationsSearchParameters getParameters() {
        return this.parameters;
    }

    public String getRelationType() {
        return this.relationType;
    }

    public List<String> getDeviceTypes() {
        return this.deviceTypes;
    }

    public void setParameters(RelationsSearchParameters parameters) {
        this.parameters = parameters;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public void setDeviceTypes(List<String> deviceTypes) {
        this.deviceTypes = deviceTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceSearchQuery)) {
            return false;
        }
        DeviceSearchQuery other = (DeviceSearchQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RelationsSearchParameters this$parameters = this.getParameters();
        RelationsSearchParameters other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$relationType = this.getRelationType();
        String other$relationType = other.getRelationType();
        if (this$relationType == null ? other$relationType != null : !this$relationType.equals(other$relationType)) {
            return false;
        }
        List<String> this$deviceTypes = this.getDeviceTypes();
        List<String> other$deviceTypes = other.getDeviceTypes();
        return !(this$deviceTypes == null ? other$deviceTypes != null : !((Object)this$deviceTypes).equals(other$deviceTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceSearchQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RelationsSearchParameters $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $relationType = this.getRelationType();
        result = result * 59 + ($relationType == null ? 43 : $relationType.hashCode());
        List<String> $deviceTypes = this.getDeviceTypes();
        result = result * 59 + ($deviceTypes == null ? 43 : ((Object)$deviceTypes).hashCode());
        return result;
    }

    public String toString() {
        return "DeviceSearchQuery(parameters=" + this.getParameters() + ", relationType=" + this.getRelationType() + ", deviceTypes=" + this.getDeviceTypes() + ")";
    }
}

