/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.event.EventFilter;
import org.thingsboard.server.common.data.event.EventType;

public class StatisticsEventFilter
implements EventFilter {
    private String server;
    private Integer messagesProcessed;
    private Integer errorsOccurred;

    @Override
    public EventType getEventType() {
        return EventType.STATS;
    }

    @Override
    public boolean hasFilterForJsonBody() {
        return !StringUtils.isEmpty(this.server) || this.messagesProcessed != null && this.messagesProcessed > 0 || this.errorsOccurred != null && this.errorsOccurred > 0;
    }

    public String getServer() {
        return this.server;
    }

    public Integer getMessagesProcessed() {
        return this.messagesProcessed;
    }

    public Integer getErrorsOccurred() {
        return this.errorsOccurred;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setMessagesProcessed(Integer messagesProcessed) {
        this.messagesProcessed = messagesProcessed;
    }

    public void setErrorsOccurred(Integer errorsOccurred) {
        this.errorsOccurred = errorsOccurred;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticsEventFilter)) {
            return false;
        }
        StatisticsEventFilter other = (StatisticsEventFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messagesProcessed = this.getMessagesProcessed();
        Integer other$messagesProcessed = other.getMessagesProcessed();
        if (this$messagesProcessed == null ? other$messagesProcessed != null : !((Object)this$messagesProcessed).equals(other$messagesProcessed)) {
            return false;
        }
        Integer this$errorsOccurred = this.getErrorsOccurred();
        Integer other$errorsOccurred = other.getErrorsOccurred();
        if (this$errorsOccurred == null ? other$errorsOccurred != null : !((Object)this$errorsOccurred).equals(other$errorsOccurred)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        return !(this$server == null ? other$server != null : !this$server.equals(other$server));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatisticsEventFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messagesProcessed = this.getMessagesProcessed();
        result = result * 59 + ($messagesProcessed == null ? 43 : ((Object)$messagesProcessed).hashCode());
        Integer $errorsOccurred = this.getErrorsOccurred();
        result = result * 59 + ($errorsOccurred == null ? 43 : ((Object)$errorsOccurred).hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        return result;
    }

    public String toString() {
        return "StatisticsEventFilter(server=" + this.getServer() + ", messagesProcessed=" + this.getMessagesProcessed() + ", errorsOccurred=" + this.getErrorsOccurred() + ")";
    }
}

