/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.page;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;

public abstract class BasePageDataIterable<T>
implements Iterable<T>,
Iterator<T> {
    private final int fetchSize;
    private List<T> currentItems;
    private int currentIdx;
    private boolean hasNextPack;
    private PageLink nextPackLink;
    private boolean initialized;

    public BasePageDataIterable(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.fetch(new PageLink(this.fetchSize));
            this.initialized = true;
        }
        if (this.currentIdx == this.currentItems.size() && this.hasNextPack) {
            this.fetch(this.nextPackLink);
        }
        return this.currentIdx < this.currentItems.size();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentItems.get(this.currentIdx++);
    }

    private void fetch(PageLink link) {
        PageData<T> pageData = this.fetchPageData(link);
        this.currentIdx = 0;
        this.currentItems = pageData.getData();
        this.hasNextPack = pageData.hasNext();
        this.nextPackLink = link.nextPageLink();
    }

    abstract PageData<T> fetchPageData(PageLink var1);
}

