/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import org.thingsboard.server.common.data.SearchTextBased;
import org.thingsboard.server.common.data.id.ComponentDescriptorId;
import org.thingsboard.server.common.data.plugin.ComponentScope;
import org.thingsboard.server.common.data.plugin.ComponentType;

public class ComponentDescriptor
extends SearchTextBased<ComponentDescriptorId> {
    private static final long serialVersionUID = 1L;
    private ComponentType type;
    private ComponentScope scope;
    private String name;
    private String clazz;
    private transient JsonNode configurationDescriptor;
    private String actions;

    public ComponentDescriptor() {
    }

    public ComponentDescriptor(ComponentDescriptorId id) {
        super(id);
    }

    public ComponentDescriptor(ComponentDescriptor plugin) {
        super(plugin);
        this.type = plugin.getType();
        this.scope = plugin.getScope();
        this.name = plugin.getName();
        this.clazz = plugin.getClazz();
        this.configurationDescriptor = plugin.getConfigurationDescriptor();
        this.actions = plugin.getActions();
    }

    @Override
    public String getSearchText() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentDescriptor that = (ComponentDescriptor)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.scope != that.scope) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) {
            return false;
        }
        if (this.configurationDescriptor != null ? !this.configurationDescriptor.equals((Object)that.configurationDescriptor) : that.configurationDescriptor != null) {
            return false;
        }
        return this.clazz != null ? this.clazz.equals(that.clazz) : that.clazz == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
        result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ComponentDescriptor(type=" + this.getType() + ", scope=" + this.getScope() + ", name=" + this.getName() + ", clazz=" + this.getClazz() + ", configurationDescriptor=" + this.getConfigurationDescriptor() + ", actions=" + this.getActions() + ")";
    }

    public ComponentType getType() {
        return this.type;
    }

    public void setType(ComponentType type) {
        this.type = type;
    }

    public ComponentScope getScope() {
        return this.scope;
    }

    public void setScope(ComponentScope scope) {
        this.scope = scope;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public JsonNode getConfigurationDescriptor() {
        return this.configurationDescriptor;
    }

    public void setConfigurationDescriptor(JsonNode configurationDescriptor) {
        this.configurationDescriptor = configurationDescriptor;
    }

    public String getActions() {
        return this.actions;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }
}

