/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.thingsboard;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.deviceMgt.DeviceDescriptor;
import de.iip_ecosphere.platform.deviceMgt.thingsboard.ThingsBoardDeviceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.thingsboard.rest.client.RestClient;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;

public class ThingsBoardDeviceRegistryTest {
    public static final String AN_IP = "AN_IP";
    public static final String ANOTHER_IP = "ANOTHER_IP";
    public static final String ANOTHER_DEVICE = "ANOTHER_DEVICE";
    private static final String A_DEVICE = "A_DEVICE";
    private ThingsBoardDeviceRegistry deviceRegistry;
    private RestClient thingsBoardMock;

    @Before
    public void setUp() {
        this.thingsBoardMock = (RestClient)Mockito.mock(RestClient.class);
        this.deviceRegistry = new ThingsBoardDeviceRegistry(this.thingsBoardMock);
    }

    @Test
    public void getIds_withTwoDevices_shouldReturnListWithTwoIds() {
        ArrayList<Device> devices = new ArrayList<Device>();
        Device d1 = new Device(new DeviceId(UUID.randomUUID()));
        d1.setName(A_DEVICE);
        Device d2 = new Device(new DeviceId(UUID.randomUUID()));
        d2.setName(ANOTHER_DEVICE);
        devices.add(d1);
        devices.add(d2);
        PageData pageData = (PageData)Mockito.mock(PageData.class);
        Mockito.when((Object)pageData.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)pageData.getData()).thenReturn(devices);
        Mockito.when((Object)this.thingsBoardMock.getTenantDevices((String)ArgumentMatchers.eq((Object)"ecs"), (PageLink)Mockito.any())).thenReturn((Object)pageData);
        Set ids = this.deviceRegistry.getIds();
        Assert.assertNotNull((Object)ids);
        Assert.assertTrue((boolean)ids.contains(A_DEVICE));
        Assert.assertTrue((boolean)ids.contains(ANOTHER_DEVICE));
        Assert.assertEquals((long)2L, (long)ids.size());
    }

    @Test
    public void getManagedIds_withTwoDevices_shouldReturnListWithTwoIds() {
        ArrayList<Device> devices = new ArrayList<Device>();
        Device d1 = new Device(new DeviceId(UUID.randomUUID()));
        d1.setName(A_DEVICE);
        Device d2 = new Device(new DeviceId(UUID.randomUUID()));
        d2.setName(ANOTHER_DEVICE);
        devices.add(d1);
        devices.add(d2);
        PageData pageData = (PageData)Mockito.mock(PageData.class);
        Mockito.when((Object)pageData.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)pageData.getData()).thenReturn(devices);
        Mockito.when((Object)this.thingsBoardMock.getTenantDevices((String)ArgumentMatchers.eq((Object)"ecs"), (PageLink)Mockito.any())).thenReturn((Object)pageData);
        Set ids = this.deviceRegistry.getManagedIds();
        Assert.assertNotNull((Object)ids);
        Assert.assertTrue((boolean)ids.contains(((DeviceId)d1.getId()).toString()));
        Assert.assertTrue((boolean)ids.contains(((DeviceId)d2.getId()).toString()));
        Assert.assertEquals((long)2L, (long)ids.size());
    }

    @Test
    public void getDevices_withTwoDevices_shouldReturnListWithTwoIds() {
        ArrayList<Device> devices = new ArrayList<Device>();
        Device d1 = new Device(new DeviceId(UUID.randomUUID()));
        d1.setName(A_DEVICE);
        Device d2 = new Device(new DeviceId(UUID.randomUUID()));
        d2.setName(ANOTHER_DEVICE);
        devices.add(d1);
        devices.add(d2);
        PageData pageData = (PageData)Mockito.mock(PageData.class);
        Mockito.when((Object)pageData.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)pageData.getData()).thenReturn(devices);
        Mockito.when((Object)this.thingsBoardMock.getTenantDevices((String)ArgumentMatchers.eq((Object)"ecs"), (PageLink)Mockito.any())).thenReturn((Object)pageData);
        Collection actualDevices = this.deviceRegistry.getDevices();
        Assert.assertEquals((long)2L, (long)actualDevices.size());
    }

    @Test
    public void getDevice_withValidId_returnsDevice() {
        Device device = this.mockDevice();
        DeviceDescriptor desc = this.deviceRegistry.getDevice(A_DEVICE);
        Assert.assertEquals((Object)A_DEVICE, (Object)desc.getId());
        Assert.assertEquals((Object)A_DEVICE, (Object)desc.getResourceId());
        Assert.assertEquals((Object)((DeviceId)device.getId()).toString(), (Object)desc.getManagedId());
    }

    @Test
    public void getDevice_withInvalidId_returnsNull() {
        Mockito.when((Object)this.thingsBoardMock.getTenantDevice((String)ArgumentMatchers.eq((Object)A_DEVICE))).thenReturn(Optional.empty());
        DeviceDescriptor desc = this.deviceRegistry.getDevice(A_DEVICE);
        Assert.assertNull((Object)desc);
    }

    @Test
    public void getDeviceByManagedId_withValidId_returnsDevice() {
        Device device = this.mockDevice();
        String id = ((DeviceId)device.getId()).toString();
        DeviceDescriptor desc = this.deviceRegistry.getDeviceByManagedId(id);
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((Object)id, (Object)desc.getManagedId());
        Assert.assertEquals((Object)device.getName(), (Object)desc.getId());
        Assert.assertEquals((Object)device.getName(), (Object)desc.getResourceId());
    }

    @Test
    public void getDeviceByManagedId_withInvalidId_returnsNull() {
        String uuid = UUID.randomUUID().toString();
        Mockito.when((Object)this.thingsBoardMock.getTenantDevice((String)ArgumentMatchers.eq((Object)uuid))).thenReturn(Optional.empty());
        DeviceDescriptor desc = this.deviceRegistry.getDeviceByManagedId(uuid);
        Assert.assertNull((Object)desc);
    }

    @Test
    public void addDevice_withValidDevice_addsADevice() throws JsonProcessingException {
        DeviceId id = new DeviceId(UUID.randomUUID());
        Device device = new Device();
        device.setType("ecs");
        device.setName(A_DEVICE);
        Mockito.when((Object)this.thingsBoardMock.saveDevice((Device)ArgumentMatchers.eq((Object)device))).thenAnswer(a -> {
            Device d = (Device)a.getArgument(0);
            d.setId((UUIDBased)id);
            return d;
        });
        this.deviceRegistry.addDevice(A_DEVICE, AN_IP);
        JsonNode attribute = this.getJsonNode("{\"ip\": \"AN_IP\"}");
        ((RestClient)Mockito.verify((Object)this.thingsBoardMock)).saveDeviceAttributes((DeviceId)ArgumentMatchers.eq((Object)id), (String)Mockito.any(), (JsonNode)ArgumentMatchers.eq((Object)attribute));
        ((RestClient)Mockito.verify((Object)this.thingsBoardMock, (VerificationMode)Mockito.times((int)1))).saveDevice((Device)Mockito.any());
    }

    @Test
    public void addDevice_withNoIp_wontAddDevice() {
        this.deviceRegistry.addDevice(A_DEVICE, null);
        this.deviceRegistry.addDevice(A_DEVICE, "");
        ((RestClient)Mockito.verify((Object)this.thingsBoardMock, (VerificationMode)Mockito.never())).saveDeviceAttributes((DeviceId)Mockito.any(), (String)Mockito.any(), (JsonNode)Mockito.any());
        ((RestClient)Mockito.verify((Object)this.thingsBoardMock, (VerificationMode)Mockito.never())).saveDevice((Device)Mockito.any());
    }

    @Test
    public void addDevice_withNoDeviceIdentifier_wontAddDevice() {
        this.deviceRegistry.addDevice(null, AN_IP);
        this.deviceRegistry.addDevice("", AN_IP);
        ((RestClient)Mockito.verify((Object)this.thingsBoardMock, (VerificationMode)Mockito.never())).saveDeviceAttributes((DeviceId)Mockito.any(), (String)Mockito.any(), (JsonNode)Mockito.any());
        ((RestClient)Mockito.verify((Object)this.thingsBoardMock, (VerificationMode)Mockito.never())).saveDevice((Device)Mockito.any());
    }

    @Test
    public void addDevice_withAlreadyRegisteredDevice_updatesDevice() {
        this.mockDevice();
        this.deviceRegistry.addDevice(A_DEVICE, ANOTHER_IP);
        ArgumentCaptor captor = ArgumentCaptor.forClass(JsonNode.class);
        ((RestClient)Mockito.verify((Object)this.thingsBoardMock, (VerificationMode)Mockito.times((int)1))).saveDeviceAttributes((DeviceId)Mockito.any(), (String)Mockito.any(), (JsonNode)captor.capture());
        ((RestClient)Mockito.verify((Object)this.thingsBoardMock, (VerificationMode)Mockito.times((int)0))).saveDevice((Device)Mockito.any());
        Assert.assertEquals((Object)ANOTHER_IP, (Object)((JsonNode)captor.getValue()).findValue("ip").asText());
    }

    @Test
    public void removeDevice_withValidDevice_removesDevice() {
        Device device = this.mockDevice();
        this.deviceRegistry.removeDevice(A_DEVICE);
        ((RestClient)Mockito.verify((Object)this.thingsBoardMock, (VerificationMode)Mockito.times((int)1))).deleteDevice((DeviceId)ArgumentMatchers.eq((Object)((DeviceId)device.getId())));
    }

    @Test
    public void removeDevice_withInvalidDevice_wontRemoveDevice() {
        this.deviceRegistry.removeDevice(A_DEVICE);
        ((RestClient)Mockito.verify((Object)this.thingsBoardMock, (VerificationMode)Mockito.times((int)0))).deleteDevice((DeviceId)Mockito.any());
    }

    @Test
    public void removeDevice_withNoDevice_wontRemoveDevice() {
        this.deviceRegistry.removeDevice("");
        this.deviceRegistry.removeDevice(null);
        ((RestClient)Mockito.verify((Object)this.thingsBoardMock, (VerificationMode)Mockito.times((int)0))).deleteDevice((DeviceId)Mockito.any());
    }

    @Test
    public void sendTelemetry_withValidData_shouldSaveTelemetry() throws ExecutionException, JsonProcessingException {
        Device device = this.mockDevice();
        this.deviceRegistry.sendTelemetry(A_DEVICE, "{\"telemetryKey\": \"telemetryValue\"}");
        ((RestClient)Mockito.verify((Object)this.thingsBoardMock)).saveEntityTelemetry((EntityId)ArgumentMatchers.eq((Object)((DeviceId)device.getId())), (String)Mockito.any(), (JsonNode)ArgumentMatchers.eq((Object)this.getJsonNode("{\"telemetryKey\": \"telemetryValue\"}")));
    }

    @Test(expected=ExecutionException.class)
    public void sendTelemetry_withInvalidData_shouldThrowException() throws ExecutionException {
        this.deviceRegistry.sendTelemetry(A_DEVICE, "{someNonsense: \"telemetryValue\"}");
        ((RestClient)Mockito.verify((Object)this.thingsBoardMock, (VerificationMode)Mockito.never())).saveEntityTelemetry((EntityId)Mockito.any(), (String)Mockito.any(), (JsonNode)Mockito.any());
    }

    @Test
    public void imAlive_sendImAliveAsTelemetry() throws JsonProcessingException, ExecutionException {
        Device device = this.mockDevice();
        this.deviceRegistry.imAlive(A_DEVICE);
        ((RestClient)Mockito.verify((Object)this.thingsBoardMock)).saveEntityTelemetry((EntityId)ArgumentMatchers.eq((Object)((DeviceId)device.getId())), (String)Mockito.any(), (JsonNode)ArgumentMatchers.eq((Object)this.getJsonNode("{\"active\": true}")));
    }

    @Test
    public void imAlive_withUnknownDevice_shouldNotSendImAliveAsTelemetry() throws JsonProcessingException, ExecutionException {
        this.deviceRegistry.imAlive(A_DEVICE);
        ((RestClient)Mockito.verify((Object)this.thingsBoardMock, (VerificationMode)Mockito.never())).saveEntityTelemetry((EntityId)Mockito.any(), (String)Mockito.any(), (JsonNode)Mockito.any());
    }

    @NotNull
    private Device mockDevice() {
        UUID deviceId = UUID.randomUUID();
        Device device = new Device(new DeviceId(deviceId));
        device.setName(A_DEVICE);
        Optional<Device> deviceOptional = Optional.of(device);
        Mockito.when((Object)this.thingsBoardMock.getTenantDevice((String)ArgumentMatchers.eq((Object)A_DEVICE))).thenReturn(deviceOptional);
        Mockito.when((Object)this.thingsBoardMock.getDeviceById((DeviceId)ArgumentMatchers.eq((Object)new DeviceId(deviceId)))).thenReturn(deviceOptional);
        return device;
    }

    private JsonNode getJsonNode(String string) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(string);
    }
}

