/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(ResourceUtils.class);

    public static InputStream getInputStream(Object classLoaderSource, String filePath) {
        return ResourceUtils.getInputStream(classLoaderSource.getClass().getClassLoader(), filePath);
    }

    public static InputStream getInputStream(ClassLoader classLoader, String filePath) {
        try {
            InputStream keyStoreInputStream;
            File keyStoreFile = new File(filePath);
            if (keyStoreFile.exists()) {
                log.info("Reading key store from file {}", (Object)filePath);
                keyStoreInputStream = new FileInputStream(keyStoreFile);
            } else {
                InputStream classPathStream = classLoader.getResourceAsStream(filePath);
                if (classPathStream != null) {
                    log.info("Reading key store from class path {}", (Object)filePath);
                    keyStoreInputStream = classPathStream;
                } else {
                    URI uri = Resources.getResource((String)filePath).toURI();
                    log.info("Reading key store from URI {}", (Object)filePath);
                    keyStoreInputStream = new FileInputStream(new File(uri));
                }
            }
            return keyStoreInputStream;
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                log.warn("Unable to find resource: " + filePath);
            } else {
                log.warn("Unable to find resource: " + filePath, (Throwable)e);
            }
            throw new RuntimeException("Unable to find resource: " + filePath);
        }
    }

    public static String getUri(Object classLoaderSource, String filePath) {
        return ResourceUtils.getUri(classLoaderSource.getClass().getClassLoader(), filePath);
    }

    public static String getUri(ClassLoader classLoader, String filePath) {
        try {
            File keyStoreFile = new File(filePath);
            if (keyStoreFile.exists()) {
                log.info("Reading key store from file {}", (Object)filePath);
                return keyStoreFile.getAbsolutePath();
            }
            URL url = classLoader.getResource(filePath);
            return url.toURI().toString();
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                log.warn("Unable to find resource: " + filePath);
            } else {
                log.warn("Unable to find resource: " + filePath, (Throwable)e);
            }
            throw new RuntimeException("Unable to find resource: " + filePath);
        }
    }
}

