/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.kv;

import java.util.Objects;
import java.util.Optional;
import org.thingsboard.server.common.data.kv.BasicKvEntry;
import org.thingsboard.server.common.data.kv.DataType;

public class LongDataEntry
extends BasicKvEntry {
    private final Long value;

    public LongDataEntry(String key, Long value) {
        super(key);
        this.value = value;
    }

    @Override
    public DataType getDataType() {
        return DataType.LONG;
    }

    @Override
    public Optional<Long> getLongValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongDataEntry)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LongDataEntry that = (LongDataEntry)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public String toString() {
        return "LongDataEntry{value=" + this.value + "} " + super.toString();
    }

    @Override
    public String getValueAsString() {
        return Long.toString(this.value);
    }
}

