/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.query;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.query.EntityDataSortOrder;

public class EntityDataPageLink {
    private int pageSize;
    private int page;
    private String textSearch;
    private EntityDataSortOrder sortOrder;
    private boolean dynamic = false;

    public EntityDataPageLink() {
    }

    public EntityDataPageLink(int pageSize, int page, String textSearch, EntityDataSortOrder sortOrder) {
        this(pageSize, page, textSearch, sortOrder, false);
    }

    @JsonIgnore
    public EntityDataPageLink nextPageLink() {
        return new EntityDataPageLink(this.pageSize, this.page + 1, this.textSearch, this.sortOrder);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPage() {
        return this.page;
    }

    public String getTextSearch() {
        return this.textSearch;
    }

    public EntityDataSortOrder getSortOrder() {
        return this.sortOrder;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setTextSearch(String textSearch) {
        this.textSearch = textSearch;
    }

    public void setSortOrder(EntityDataSortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityDataPageLink)) {
            return false;
        }
        EntityDataPageLink other = (EntityDataPageLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.isDynamic() != other.isDynamic()) {
            return false;
        }
        String this$textSearch = this.getTextSearch();
        String other$textSearch = other.getTextSearch();
        if (this$textSearch == null ? other$textSearch != null : !this$textSearch.equals(other$textSearch)) {
            return false;
        }
        EntityDataSortOrder this$sortOrder = this.getSortOrder();
        EntityDataSortOrder other$sortOrder = other.getSortOrder();
        return !(this$sortOrder == null ? other$sortOrder != null : !((Object)this$sortOrder).equals(other$sortOrder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityDataPageLink;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getPage();
        result = result * 59 + (this.isDynamic() ? 79 : 97);
        String $textSearch = this.getTextSearch();
        result = result * 59 + ($textSearch == null ? 43 : $textSearch.hashCode());
        EntityDataSortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)$sortOrder).hashCode());
        return result;
    }

    public String toString() {
        return "EntityDataPageLink(pageSize=" + this.getPageSize() + ", page=" + this.getPage() + ", textSearch=" + this.getTextSearch() + ", sortOrder=" + this.getSortOrder() + ", dynamic=" + this.isDynamic() + ")";
    }

    @ConstructorProperties(value={"pageSize", "page", "textSearch", "sortOrder", "dynamic"})
    public EntityDataPageLink(int pageSize, int page, String textSearch, EntityDataSortOrder sortOrder, boolean dynamic) {
        this.pageSize = pageSize;
        this.page = page;
        this.textSearch = textSearch;
        this.sortOrder = sortOrder;
        this.dynamic = dynamic;
    }
}

