/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.EdgeEventType;

public final class EdgeUtils {
    private static final Logger log = LoggerFactory.getLogger(EdgeUtils.class);

    private EdgeUtils() {
    }

    public static EdgeEventType getEdgeEventTypeByEntityType(EntityType entityType) {
        switch (entityType) {
            case EDGE: {
                return EdgeEventType.EDGE;
            }
            case DEVICE: {
                return EdgeEventType.DEVICE;
            }
            case DEVICE_PROFILE: {
                return EdgeEventType.DEVICE_PROFILE;
            }
            case ASSET: {
                return EdgeEventType.ASSET;
            }
            case ENTITY_VIEW: {
                return EdgeEventType.ENTITY_VIEW;
            }
            case DASHBOARD: {
                return EdgeEventType.DASHBOARD;
            }
            case USER: {
                return EdgeEventType.USER;
            }
            case RULE_CHAIN: {
                return EdgeEventType.RULE_CHAIN;
            }
            case ALARM: {
                return EdgeEventType.ALARM;
            }
            case TENANT: {
                return EdgeEventType.TENANT;
            }
            case CUSTOMER: {
                return EdgeEventType.CUSTOMER;
            }
            case WIDGETS_BUNDLE: {
                return EdgeEventType.WIDGETS_BUNDLE;
            }
            case WIDGET_TYPE: {
                return EdgeEventType.WIDGET_TYPE;
            }
        }
        log.warn("Unsupported entity type [{}]", (Object)entityType);
        return null;
    }

    public static int nextPositiveInt() {
        return ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE);
    }
}

