/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.security;

import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.id.UserCredentialsId;
import org.thingsboard.server.common.data.id.UserId;

public class UserCredentials
extends BaseData<UserCredentialsId> {
    private static final long serialVersionUID = -2108436378880529163L;
    private UserId userId;
    private boolean enabled;
    private String password;
    private String activateToken;
    private String resetToken;

    public UserCredentials() {
    }

    public UserCredentials(UserCredentialsId id) {
        super(id);
    }

    public UserCredentials(UserCredentials userCredentials) {
        super(userCredentials);
        this.userId = userCredentials.getUserId();
        this.password = userCredentials.getPassword();
        this.enabled = userCredentials.isEnabled();
        this.activateToken = userCredentials.getActivateToken();
        this.resetToken = userCredentials.getResetToken();
    }

    public UserId getUserId() {
        return this.userId;
    }

    public void setUserId(UserId userId) {
        this.userId = userId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getActivateToken() {
        return this.activateToken;
    }

    public void setActivateToken(String activateToken) {
        this.activateToken = activateToken;
    }

    public String getResetToken() {
        return this.resetToken;
    }

    public void setResetToken(String resetToken) {
        this.resetToken = resetToken;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UserCredentials [userId=");
        builder.append(this.userId);
        builder.append(", enabled=");
        builder.append(this.enabled);
        builder.append(", password=");
        builder.append(this.password);
        builder.append(", activateToken=");
        builder.append(this.activateToken);
        builder.append(", resetToken=");
        builder.append(this.resetToken);
        builder.append(", createdTime=");
        builder.append(this.createdTime);
        builder.append(", id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserCredentials)) {
            return false;
        }
        UserCredentials other = (UserCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        UserId this$userId = this.getUserId();
        UserId other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$activateToken = this.getActivateToken();
        String other$activateToken = other.getActivateToken();
        if (this$activateToken == null ? other$activateToken != null : !this$activateToken.equals(other$activateToken)) {
            return false;
        }
        String this$resetToken = this.getResetToken();
        String other$resetToken = other.getResetToken();
        return !(this$resetToken == null ? other$resetToken != null : !this$resetToken.equals(other$resetToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserCredentials;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        UserId $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $activateToken = this.getActivateToken();
        result = result * 59 + ($activateToken == null ? 43 : $activateToken.hashCode());
        String $resetToken = this.getResetToken();
        result = result * 59 + ($resetToken == null ? 43 : $resetToken.hashCode());
        return result;
    }
}

