/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt;

import de.iip_ecosphere.platform.deviceMgt.DeviceFirmwareOperations;
import de.iip_ecosphere.platform.deviceMgt.DeviceManagement;
import de.iip_ecosphere.platform.deviceMgt.DeviceRemoteManagementOperations;
import de.iip_ecosphere.platform.deviceMgt.DeviceResourceConfigOperations;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistry;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryFactory;
import java.util.concurrent.ExecutionException;

public class DeviceManagementImpl
implements DeviceManagement {
    private DeviceFirmwareOperations firmwareOperations;
    private DeviceRemoteManagementOperations remoteManagementOperations;
    private DeviceResourceConfigOperations resourceConfigOperations;
    private final DeviceRegistry deviceRegistry;

    public DeviceManagementImpl(DeviceFirmwareOperations firmwareOperations, DeviceRemoteManagementOperations remoteManagementOperations, DeviceResourceConfigOperations resourceConfigOperations) {
        this.firmwareOperations = firmwareOperations;
        this.remoteManagementOperations = remoteManagementOperations;
        this.resourceConfigOperations = resourceConfigOperations;
        this.deviceRegistry = DeviceRegistryFactory.getDeviceRegistry();
    }

    @Override
    public void updateRuntime(String id) throws ExecutionException {
        if (this.deviceRegistry.getDevice(id) == null) {
            return;
        }
        this.firmwareOperations.updateRuntime(id);
    }

    @Override
    public DeviceRemoteManagementOperations.SSHConnectionDetails establishSsh(String id) throws ExecutionException {
        if (this.deviceRegistry.getDevice(id) == null) {
            return null;
        }
        return this.remoteManagementOperations.establishSsh(id);
    }

    @Override
    public void setConfig(String id, String configPath) throws ExecutionException {
        if (this.deviceRegistry.getDevice(id) == null) {
            return;
        }
        this.resourceConfigOperations.setConfig(id, configPath);
    }
}

