/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.registry;

import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistrationResponse;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryAasClient;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryFactory;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import java.io.Serializable;
import java.util.function.Function;

public class DeviceRegistryAas
implements AasContributor {
    public static final String NAME_SUBMODEL = "resources";
    public static final String NAME_COLL_DEVICE_REGISTRY = "deviceRegistry";
    public static final String NAME_PROP_DEVICE_RESOURCE = "resource";
    public static final String NAME_PROP_MANAGED_DEVICE_ID = "managedId";
    public static final String NAME_PROP_DEVICE_IP = "ip";
    public static final String NAME_OP_DEVICE_ADD = "addDevice";
    public static final String NAME_OP_DEVICE_REMOVE = "removeDevice";
    public static final String NAME_OP_IM_ALIVE = "imAlive";
    public static final String NAME_OP_SEND_TELEMETRY = "sendTelemetry";

    public Aas contributeTo(Aas.AasBuilder aasBuilder, InvocablesCreator iCreator) {
        AuthenticationDescriptor aDesc = this.getSubmodelAuthentication();
        Submodel.SubmodelBuilder smB = (Submodel.SubmodelBuilder)AasPartRegistry.createSubmodelBuilder((Aas.AasBuilder)aasBuilder, (String)NAME_SUBMODEL).rbacDevice(aDesc);
        SubmodelElementCollection.SubmodelElementCollectionBuilder registryColl = smB.createSubmodelElementCollectionBuilder(NAME_COLL_DEVICE_REGISTRY);
        registryColl.createOperationBuilder(NAME_OP_DEVICE_ADD).setInvocable(iCreator.createInvocable(DeviceRegistryAas.getQName(NAME_OP_DEVICE_ADD))).addInputVariable("deviceId", Type.STRING).addInputVariable("deviceIp", Type.STRING).build(aDesc);
        registryColl.createOperationBuilder(NAME_OP_DEVICE_REMOVE).setInvocable(iCreator.createInvocable(DeviceRegistryAas.getQName(NAME_OP_DEVICE_REMOVE))).addInputVariable("deviceId", Type.STRING).build(aDesc);
        registryColl.createOperationBuilder(NAME_OP_IM_ALIVE).setInvocable(iCreator.createInvocable(DeviceRegistryAas.getQName(NAME_OP_IM_ALIVE))).addInputVariable("deviceId", Type.STRING).build(aDesc);
        registryColl.createOperationBuilder(NAME_OP_SEND_TELEMETRY).setInvocable(iCreator.createInvocable(DeviceRegistryAas.getQName(NAME_OP_SEND_TELEMETRY))).addInputVariable("deviceId", Type.STRING).addInputVariable("telemetryData", Type.STRING).build(aDesc);
        registryColl.build();
        smB.defer();
        return null;
    }

    public void contributeTo(ProtocolServerBuilder sBuilder) {
        sBuilder.defineOperation(DeviceRegistryAas.getQName(NAME_OP_DEVICE_ADD), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            DeviceRegistrationResponse resp = DeviceRegistryFactory.getDeviceRegistry().addDevice(AasUtils.readString((Object[])p), AasUtils.readString((Object[])p, (int)1));
            return JsonUtils.toJson((Object)resp);
        }));
        sBuilder.defineOperation(DeviceRegistryAas.getQName(NAME_OP_DEVICE_REMOVE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            DeviceRegistryFactory.getDeviceRegistry().removeDevice(AasUtils.readString((Object[])p));
            return null;
        }));
        sBuilder.defineOperation(DeviceRegistryAas.getQName(NAME_OP_IM_ALIVE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            DeviceRegistryFactory.getDeviceRegistry().imAlive(AasUtils.readString((Object[])p));
            return null;
        }));
        sBuilder.defineOperation(DeviceRegistryAas.getQName(NAME_OP_SEND_TELEMETRY), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            DeviceRegistryFactory.getDeviceRegistry().sendTelemetry(AasUtils.readString((Object[])p), AasUtils.readString((Object[])p, (int)1));
            return null;
        }));
    }

    private static String getQName(String name) {
        return "deviceRegistry_" + name;
    }

    public AasContributor.Kind getKind() {
        return AasContributor.Kind.ACTIVE;
    }

    public boolean isValid() {
        return null != DeviceRegistryFactory.getDeviceRegistry();
    }

    public static void notifyDeviceAdded(String managedId, String resourceId, String resourceIp) {
        ActiveAasBase.processNotification((String)NAME_SUBMODEL, (sub, aas) -> {
            AuthenticationDescriptor aDesc = AasPartRegistry.getSubmodelAuthentication();
            Submodel.SubmodelBuilder resources = (Submodel.SubmodelBuilder)AasPartRegistry.createSubmodelBuilder((Aas)aas, (String)NAME_SUBMODEL).rbacDevice(aDesc);
            SubmodelElementCollection.SubmodelElementCollectionBuilder registry = resources.createSubmodelElementCollectionBuilder(NAME_COLL_DEVICE_REGISTRY);
            SubmodelElementCollection.SubmodelElementCollectionBuilder device = resources.createSubmodelElementCollectionBuilder(AasUtils.fixId((String)resourceId));
            device.createPropertyBuilder(NAME_PROP_MANAGED_DEVICE_ID).setValue(Type.STRING, (Object)managedId).build(aDesc);
            device.createPropertyBuilder(NAME_PROP_DEVICE_IP).setValue(Type.STRING, (Object)resourceIp).build(aDesc);
            device.build();
            registry.build();
            resources.build();
        });
    }

    public static void notifyDeviceRemoved(String resourceId) {
        ActiveAasBase.processNotification((String)NAME_SUBMODEL, (sub, aas) -> {
            DeviceRegistryAasClient client = new DeviceRegistryAasClient();
            SubmodelElementCollection device = client.getDevice(AasUtils.fixId((String)resourceId));
            if (null != device) {
                device.deleteElement(NAME_PROP_MANAGED_DEVICE_ID);
                device.deleteElement(NAME_PROP_DEVICE_IP);
            }
        });
    }
}

