/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.registry;

import de.iip_ecosphere.platform.deviceMgt.DeviceDescriptor;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistry;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryFactory;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryFactoryDescriptor;
import de.iip_ecosphere.platform.deviceMgt.registry.StubDeviceRegistryFactoryDescriptor;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class DeviceRegistryFactoryTest {
    public static final String A_DEVICE_ID = "A_DEVICE_ID";
    public static final String SOME_TELEMETRY = "someTelemetry";
    public static final String AN_IP = "1.1.1.1";
    public static final String A_SECRET = "A_SECRET";

    @After
    public void tearDown() throws Exception {
        Mockito.reset((Object[])new DeviceRegistry[]{StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry()});
    }

    @Test
    public void getDeviceRegistry_withServiceLoaderConfiguration_returnsDeviceRegistry() {
        DeviceRegistry stubRegistry = StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry();
        Mockito.when((Object)stubRegistry.getIds()).thenReturn(Collections.singleton(A_DEVICE_ID));
        Assert.assertNotNull((Object)DeviceRegistryFactory.getDeviceRegistry());
        DeviceRegistry dReg = DeviceRegistryFactory.getDeviceRegistry();
        Assert.assertTrue((boolean)dReg.getIds().contains(A_DEVICE_ID));
    }

    @Test
    public void allFunctions_withFakeRegistry_callsDownstreamRegistryFunction() throws ExecutionException {
        ActiveAasBase.NotificationMode origMode = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.NONE);
        DeviceRegistry stubRegistry = StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry();
        DeviceRegistry deviceRegistry = DeviceRegistryFactory.getDeviceRegistry();
        deviceRegistry.getDevices();
        ((DeviceRegistry)Mockito.verify((Object)stubRegistry)).getDevices();
        deviceRegistry.getDevice(A_DEVICE_ID);
        ((DeviceRegistry)Mockito.verify((Object)stubRegistry)).getDevice((String)Mockito.eq((Object)A_DEVICE_ID));
        deviceRegistry.removeDevice(A_DEVICE_ID);
        ((DeviceRegistry)Mockito.verify((Object)stubRegistry)).removeDevice((String)Mockito.eq((Object)A_DEVICE_ID));
        deviceRegistry.addDevice(A_DEVICE_ID, AN_IP);
        ((DeviceRegistry)Mockito.verify((Object)stubRegistry)).addDevice((String)Mockito.eq((Object)A_DEVICE_ID), (String)Mockito.eq((Object)AN_IP));
        deviceRegistry.imAlive(A_DEVICE_ID);
        ((DeviceRegistry)Mockito.verify((Object)stubRegistry)).imAlive((String)Mockito.eq((Object)A_DEVICE_ID));
        deviceRegistry.sendTelemetry(A_DEVICE_ID, SOME_TELEMETRY);
        ((DeviceRegistry)Mockito.verify((Object)stubRegistry)).sendTelemetry((String)Mockito.eq((Object)A_DEVICE_ID), (String)Mockito.eq((Object)SOME_TELEMETRY));
        deviceRegistry.getDeviceByManagedId(A_DEVICE_ID);
        ((DeviceRegistry)Mockito.verify((Object)stubRegistry)).getDeviceByManagedId((String)Mockito.eq((Object)A_DEVICE_ID));
        deviceRegistry.getManagedIds();
        ((DeviceRegistry)Mockito.verify((Object)stubRegistry)).getManagedIds();
        deviceRegistry.getIds();
        ((DeviceRegistry)Mockito.verify((Object)stubRegistry)).getIds();
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)origMode);
    }

    @Test
    public void getDevice_returnsDeviceFromDeviceRegistry() {
        DeviceRegistry reg = StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry();
        DeviceDescriptor deviceDescriptor = (DeviceDescriptor)Mockito.mock(DeviceDescriptor.class);
        DeviceDescriptor.State aState = DeviceDescriptor.State.AVAILABLE;
        Mockito.when((Object)deviceDescriptor.getState()).thenReturn((Object)aState);
        Mockito.when((Object)reg.getDevice((String)Mockito.eq((Object)A_DEVICE_ID))).thenReturn((Object)deviceDescriptor);
        DeviceDescriptor device = DeviceRegistryFactory.getDeviceRegistry().getDevice(A_DEVICE_ID);
        Assert.assertEquals((Object)deviceDescriptor, (Object)device);
        Assert.assertEquals((Object)aState, (Object)device.getState());
    }

    @Test
    public void getDeviceRegistry_withNoPlugin_returnsNull() {
        MockedStatic serviceLoader = Mockito.mockStatic(ServiceLoaderUtils.class);
        serviceLoader.when(() -> ServiceLoaderUtils.findFirst(DeviceRegistryFactoryDescriptor.class)).thenReturn(Optional.empty());
        DeviceRegistryFactory.resetDeviceRegistryFactory();
        Assert.assertNull((Object)DeviceRegistryFactory.getDeviceRegistry());
        serviceLoader.close();
    }
}

