/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.ssh;

import de.iip_ecosphere.platform.deviceMgt.ssh.Connection;
import de.iip_ecosphere.platform.deviceMgt.ssh.Proxy;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class SshProxyServer
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Proxy.class);
    private final String remoteIp;
    private final int remotePort;
    private int port;
    private ServerSocket serverSocket;

    public SshProxyServer(String remoteIp, int remotePort, int localPort) {
        this.remoteIp = remoteIp;
        this.remotePort = remotePort;
        this.port = localPort;
    }

    public void listen() throws IOException {
        if (null == this.serverSocket) {
            this.serverSocket = new ServerSocket(this.port);
            this.port = this.serverSocket.getLocalPort();
            while (true) {
                Socket socket = this.serverSocket.accept();
                this.startThread(new Connection(socket, this.remoteIp, this.remotePort));
            }
        }
    }

    public void stop() throws IOException {
        if (null != this.serverSocket) {
            this.serverSocket.close();
            this.serverSocket = null;
        }
    }

    private void startThread(Connection connection) {
        Thread t = new Thread(connection);
        t.start();
    }

    public String getRemoteIp() {
        return this.remoteIp;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void run() {
        try {
            this.listen();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
    }
}

