/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt;

import de.iip_ecosphere.platform.deviceMgt.DeviceDescriptor;
import de.iip_ecosphere.platform.deviceMgt.DeviceFirmwareOperations;
import de.iip_ecosphere.platform.deviceMgt.DeviceManagementAas;
import de.iip_ecosphere.platform.deviceMgt.DeviceManagementAasClient;
import de.iip_ecosphere.platform.deviceMgt.DeviceManagementFactory;
import de.iip_ecosphere.platform.deviceMgt.DeviceRemoteManagementOperations;
import de.iip_ecosphere.platform.deviceMgt.DeviceResourceConfigOperations;
import de.iip_ecosphere.platform.deviceMgt.MockInterceptor;
import de.iip_ecosphere.platform.deviceMgt.StubDeviceManagement;
import de.iip_ecosphere.platform.deviceMgt.StubEcsAas;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistry;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryAasClient;
import de.iip_ecosphere.platform.deviceMgt.registry.StubDeviceRegistryFactoryDescriptor;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasPrintVisitor;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.OperationsProvider;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import test.de.iip_ecosphere.platform.support.aas.TestWithPlugin;

@RunWith(value=MockitoJUnitRunner.class)
public class DeviceManagementAasTest
extends TestWithPlugin {
    public static final String A_DEVICE_ID = "A_DEVICE";
    public static final String A_DEVICE_IP = "A_DEVICE_IP";
    public static final String A_CONFIG_PATH = "A_CONFIG_PATH";
    public static final String A_CONFIG_DOWNLOAD_URI = "A_CONFIG_DOWNLOAD_URI";
    public static final String A_LOCATION = "A_LOCATION";
    public static final String A_DOWNLOADURL = "A_DOWNLOADURL";
    private static Aas aas;
    private static Server implServer;
    private static Server aasServer;
    private static MockedStatic<ServiceLoaderUtils> serviceLoader;
    private static MockInterceptor interceptor;

    @BeforeClass
    public static void startup() throws IOException {
        DeviceManagementAasTest.loadPlugins();
        AasPartRegistry.AasBuildResult res = AasPartRegistry.build();
        res.getProtocolServerBuilder().setInterceptor((OperationsProvider.Interceptor)interceptor);
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)AasPartRegistry.AasSetup.createLocalEphemeralSetup(), (boolean)true);
        implServer = (Server)res.getProtocolServerBuilder().build();
        implServer.start();
        aasServer = AasPartRegistry.deploy((List)res.getAas(), (String[])new String[0]);
        aasServer.start();
        aas = AasPartRegistry.retrieveIipAas();
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS);
    }

    @AfterClass
    public static void shutdown() {
        implServer.stop(false);
        aasServer.stop(false);
    }

    @After
    public void tearDown() throws Exception {
        interceptor.clear();
        Mockito.reset((Object[])new DeviceRegistry[]{StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry()});
        Mockito.reset((Object[])new DeviceFirmwareOperations[]{StubDeviceManagement.mockFirmwareOperations()});
        Mockito.reset((Object[])new DeviceResourceConfigOperations[]{StubDeviceManagement.mockResourceConfigOperations()});
        Mockito.reset((Object[])new JsonResultWrapper[]{StubEcsAas.getCreateRemoteConnectionCredentialsMock()});
        Mockito.reset((Object[])new JsonResultWrapper[]{StubEcsAas.getUpdateRuntimeMock()});
        Mockito.reset((Object[])new JsonResultWrapper[]{StubEcsAas.getSetConfigMock()});
        if (serviceLoader != null && !serviceLoader.isClosed()) {
            serviceLoader.close();
            DeviceManagementFactory.resetDeviceManagement();
        }
        AasPartRegistry.retrieveIipAas().accept((AasVisitor)new AasPrintVisitor());
    }

    @Before
    public void setUp() throws Exception {
        AasPartRegistry.retrieveIipAas().accept((AasVisitor)new AasPrintVisitor());
    }

    @Test
    public void init_contributorClassLoads() {
        Assert.assertTrue((boolean)AasPartRegistry.contributorClasses().contains(DeviceManagementAas.class));
    }

    @Test
    public void init_contributedAasIsDeployed() throws IOException {
        AasPartRegistry.retrieveIipAas().accept((AasVisitor)new AasPrintVisitor());
        Submodel resourcesSubmodel = aas.getSubmodel("resources");
        Assert.assertNotNull((Object)resourcesSubmodel);
        SubmodelElementCollection deviceManager = resourcesSubmodel.getSubmodelElementCollection("deviceManager");
        Assert.assertNotNull((Object)deviceManager);
    }

    @Test
    public void getKind_shouldBeActive() {
        AasContributor.Kind kind = new DeviceManagementAas().getKind();
        Assert.assertEquals((Object)AasContributor.Kind.ACTIVE, (Object)kind);
    }

    @Test
    public void op_updateRuntime_withInvalidDeviceAndAasDevManager_wontUpdateRuntime() throws IOException, ExecutionException {
        DeviceManagementAasTest.unloadFirmwareOperations();
        new DeviceManagementAasClient().updateRuntime(A_DEVICE_ID);
        ((JsonResultWrapper)Mockito.verify((Object)StubEcsAas.getUpdateRuntimeMock(), (VerificationMode)Mockito.times((int)0))).apply((Object[])Mockito.any());
    }

    @Test
    public void op_updateRuntime_withValidDeviceAndAasDevManager_updatesRuntimeOnDevice() throws IOException, ExecutionException {
        DeviceManagementAasTest.makeDeviceAvailable();
        DeviceManagementAasTest.unloadFirmwareOperations();
        new DeviceManagementAasClient().updateRuntime(A_DEVICE_ID);
        Assert.assertTrue((interceptor.getCalls("resources_updateRuntime") == 1 ? 1 : 0) != 0);
    }

    private Set<String> validRuntimesReducedListing() {
        HashSet<String> listing = new HashSet<String>();
        listing.add("runtimes/stubRuntime_1");
        listing.add("runtimes/stubRuntime_2");
        listing.add("runtimes/stubRuntime_3");
        listing.add("runtimes/def");
        listing.add("runtimes/ghi");
        return listing;
    }

    @Test
    public void op_updateRuntime_withInvalidDeviceAndLoadedDevManager_wontUpdateRuntime() throws IOException, ExecutionException {
        DeviceFirmwareOperations deviceFirmwareOperations = StubDeviceManagement.mockFirmwareOperations();
        new DeviceManagementAasClient().updateRuntime(A_DEVICE_ID);
        ((DeviceFirmwareOperations)Mockito.verify((Object)deviceFirmwareOperations, (VerificationMode)Mockito.never())).updateRuntime((String)ArgumentMatchers.eq((Object)A_DEVICE_ID));
    }

    @Test
    public void op_updateRuntime_withValidDeviceAndLoadedDevManager_updatesRuntimeOnDevice() throws IOException, ExecutionException {
        DeviceManagementAasTest.makeDeviceAvailable();
        new DeviceManagementAasClient().updateRuntime(A_DEVICE_ID);
        Assert.assertTrue((interceptor.getCalls("resources_updateRuntime") == 1 ? 1 : 0) != 0);
    }

    @Test
    public void op_setConfig_withInvalidDeviceAndAasDevManager_wontSetConfig() throws IOException, ExecutionException {
        DeviceManagementAasTest.unloadFirmwareOperations();
        new DeviceManagementAasClient().setConfig(A_DEVICE_ID, A_CONFIG_PATH);
        ((JsonResultWrapper)Mockito.verify((Object)StubEcsAas.getSetConfigMock(), (VerificationMode)Mockito.times((int)0))).apply((Object[])Mockito.any());
    }

    @Test
    public void op_setConfig_withValidDeviceAndAasDevManager_setsConfigOnDevice() throws IOException, ExecutionException {
        DeviceManagementAasTest.makeDeviceAvailable();
        DeviceManagementAasTest.unloadResourceConfigOperations();
        new DeviceManagementAasClient().setConfig(A_DEVICE_ID, A_CONFIG_PATH);
        ((JsonResultWrapper)Mockito.verify((Object)StubEcsAas.getSetConfigMock(), (VerificationMode)Mockito.times((int)1))).apply((Object[])ArgumentMatchers.eq((Object)new String[]{A_CONFIG_DOWNLOAD_URI, A_LOCATION}));
    }

    @Test
    public void op_setConfig_withInvalidDeviceAndLoadedDevManager_wontSetConfig() throws IOException, ExecutionException {
        DeviceResourceConfigOperations configOperations = StubDeviceManagement.mockResourceConfigOperations();
        new DeviceManagementAasClient().setConfig(A_DEVICE_ID, A_CONFIG_PATH);
        ((DeviceResourceConfigOperations)Mockito.verify((Object)configOperations, (VerificationMode)Mockito.never())).setConfig((String)ArgumentMatchers.eq((Object)A_DEVICE_ID), (String)ArgumentMatchers.eq((Object)A_CONFIG_PATH));
    }

    @Test
    public void op_setConfig_withValidDeviceAndLoadedDevManager_setsConfigOnDevice() throws IOException, ExecutionException {
        DeviceManagementAasTest.makeDeviceAvailable();
        new DeviceManagementAasClient().setConfig(A_DEVICE_ID, A_CONFIG_PATH);
        Assert.assertTrue((interceptor.getCalls("resources_setConfig") == 1 ? 1 : 0) != 0);
    }

    @Test
    public void op_establishSsh_withValidDeviceAndLoadedDevManager_createsConnectionDetails() throws IOException, ExecutionException {
        DeviceRemoteManagementOperations.SSHConnectionDetails expectedConnectionDetails = new DeviceRemoteManagementOperations.SSHConnectionDetails(A_DEVICE_IP, Integer.valueOf(1234), "username", "password");
        DeviceManagementAasTest.makeDeviceAvailable();
        interceptor.intercept("resources_establishSsh", p -> JsonUtils.toJson((Object)expectedConnectionDetails));
        DeviceRemoteManagementOperations.SSHConnectionDetails connectionDetails = new DeviceManagementAasClient().establishSsh(A_DEVICE_ID);
        Assert.assertEquals((Object)expectedConnectionDetails, (Object)connectionDetails);
        Assert.assertTrue((interceptor.getCalls("resources_establishSsh") == 1 ? 1 : 0) != 0);
    }

    @Test
    public void op_establishSsh_withValidDeviceAndDefaultDevManager_letsDeviceCreateCredentials() throws IOException, ExecutionException {
        DeviceManagementAasTest.unloadRemoteAccessOperations();
        DeviceManagementAasTest.makeDeviceAvailable();
        DeviceRemoteManagementOperations.SSHConnectionDetails expectedConnectionDetails = new DeviceRemoteManagementOperations.SSHConnectionDetails(A_DEVICE_IP, Integer.valueOf(5555), "username", "password");
        Mockito.when((Object)StubEcsAas.getCreateRemoteConnectionCredentialsMock().apply((Object[])Mockito.any())).thenReturn((Object)"{\"key\": \"username\", \"secret\": \"password\"}");
        DeviceRemoteManagementOperations.SSHConnectionDetails connectionDetails = new DeviceManagementAasClient().establishSsh(A_DEVICE_ID);
        ((JsonResultWrapper)Mockito.verify((Object)StubEcsAas.getCreateRemoteConnectionCredentialsMock(), (VerificationMode)Mockito.times((int)1))).apply((Object[])ArgumentMatchers.eq((Object)new String[0]));
        Assert.assertEquals((Object)expectedConnectionDetails, (Object)connectionDetails);
    }

    @Test
    public void op_establishSsh_withValidDeviceAndInvalidDeviceResponse_returnsNull() throws IOException, ExecutionException {
        DeviceManagementAasTest.unloadRemoteAccessOperations();
        DeviceManagementAasTest.makeDeviceAvailable();
        Mockito.when((Object)StubEcsAas.getCreateRemoteConnectionCredentialsMock().apply((Object[])Mockito.any())).thenReturn((Object)"{\"jsonWithoutTheRightKeys\": \"some_nonesense\", \"anotherField\": \"anotherValue\"}");
        DeviceRemoteManagementOperations.SSHConnectionDetails connectionDetails = new DeviceManagementAasClient().establishSsh(A_DEVICE_ID);
        ((JsonResultWrapper)Mockito.verify((Object)StubEcsAas.getCreateRemoteConnectionCredentialsMock(), (VerificationMode)Mockito.times((int)1))).apply((Object[])ArgumentMatchers.eq((Object)new String[0]));
        Assert.assertNull((Object)connectionDetails);
    }

    static void unloadFirmwareOperations() {
        serviceLoader = Mockito.mockStatic(ServiceLoaderUtils.class);
        serviceLoader.when(() -> ServiceLoaderUtils.findFirst(DeviceFirmwareOperations.class)).thenReturn(Optional.empty());
        DeviceManagementAasTest.resetDeviceManagement();
    }

    static void unloadResourceConfigOperations() {
        serviceLoader = Mockito.mockStatic(ServiceLoaderUtils.class);
        serviceLoader.when(() -> ServiceLoaderUtils.findFirst(DeviceResourceConfigOperations.class)).thenReturn(Optional.empty());
        DeviceManagementAasTest.resetDeviceManagement();
    }

    static void unloadRemoteAccessOperations() {
        serviceLoader = Mockito.mockStatic(ServiceLoaderUtils.class);
        serviceLoader.when(() -> ServiceLoaderUtils.findFirst(DeviceRemoteManagementOperations.class)).thenReturn(Optional.empty());
        DeviceManagementAasTest.resetDeviceManagement();
    }

    static void makeDeviceAvailable() throws ExecutionException, IOException {
        new DeviceRegistryAasClient().addDevice(A_DEVICE_ID, A_DEVICE_IP);
        DeviceDescriptor mockDevice = (DeviceDescriptor)Mockito.mock(DeviceDescriptor.class);
        Mockito.when((Object)StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry().getDevice((String)ArgumentMatchers.eq((Object)A_DEVICE_ID))).thenReturn((Object)mockDevice);
    }

    private static void resetDeviceManagement() {
        DeviceManagementFactory.resetDeviceManagement();
        DeviceManagementFactory.getDeviceManagement();
    }

    static {
        interceptor = new MockInterceptor();
    }
}

