/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.authorization.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Consumer;
import org.eclipse.basyx.components.aas.aascomponent.IAASServerDecorator;
import org.eclipse.basyx.components.aas.authorization.AuthorizedAASServerFeature;
import org.eclipse.basyx.components.aas.authorization.internal.AuthorizedAASServerDecorator;
import org.eclipse.basyx.components.aas.authorization.internal.AuthorizedDefaultServletParams;
import org.eclipse.basyx.components.aas.authorization.internal.PathTargetInformation;
import org.eclipse.basyx.components.aas.authorization.internal.SimpleRbacFilesAuthorizer;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxSecurityConfiguration;
import org.eclipse.basyx.components.security.authorization.internal.AuthorizationDynamicClassLoader;
import org.eclipse.basyx.extensions.aas.aggregator.authorization.internal.SimpleRbacAASAggregatorAuthorizer;
import org.eclipse.basyx.extensions.aas.api.authorization.internal.SimpleRbacAASAPIAuthorizer;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRbacRuleChecker;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRoleAuthenticator;
import org.eclipse.basyx.extensions.shared.authorization.internal.ISubjectInformationProvider;
import org.eclipse.basyx.extensions.shared.authorization.internal.PredefinedSetRbacRuleChecker;
import org.eclipse.basyx.extensions.shared.authorization.internal.RbacRuleSet;
import org.eclipse.basyx.extensions.shared.authorization.internal.RbacRuleSetDeserializer;
import org.eclipse.basyx.extensions.submodel.aggregator.authorization.internal.SimpleRbacSubmodelAggregatorAuthorizer;
import org.eclipse.basyx.extensions.submodel.authorization.internal.SimpleRbacSubmodelAPIAuthorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRbacAuthorizedAASServerFeature<SubjectInformationType>
extends AuthorizedAASServerFeature<SubjectInformationType> {
    private static Logger logger = LoggerFactory.getLogger(SimpleRbacAuthorizedAASServerFeature.class);

    public SimpleRbacAuthorizedAASServerFeature(BaSyxSecurityConfiguration securityConfig) {
        super(securityConfig);
    }

    @Override
    public IAASServerDecorator getDecorator() {
        logger.info("use SimpleRbac authorization strategy");
        RbacRuleSet rbacRuleSet = this.getRbacRuleSet();
        PredefinedSetRbacRuleChecker rbacRuleChecker = new PredefinedSetRbacRuleChecker(rbacRuleSet);
        IRoleAuthenticator<SubjectInformationType> roleAuthenticator = this.getSimpleRbacRoleAuthenticator();
        ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider = this.getSimpleRbacSubjectInformationProvider();
        return new AuthorizedAASServerDecorator<SubjectInformationType>(new SimpleRbacSubmodelAPIAuthorizer((IRbacRuleChecker)rbacRuleChecker, roleAuthenticator), new SimpleRbacSubmodelAggregatorAuthorizer((IRbacRuleChecker)rbacRuleChecker, roleAuthenticator), new SimpleRbacAASAPIAuthorizer((IRbacRuleChecker)rbacRuleChecker, roleAuthenticator), new SimpleRbacAASAggregatorAuthorizer((IRbacRuleChecker)rbacRuleChecker, roleAuthenticator), subjectInformationProvider);
    }

    @Override
    public AuthorizedDefaultServletParams<SubjectInformationType> getFilesAuthorizerParams() {
        logger.info("use SimpleRbac authorization strategy");
        RbacRuleSet rbacRuleSet = this.getRbacRuleSet();
        PredefinedSetRbacRuleChecker rbacRuleChecker = new PredefinedSetRbacRuleChecker(rbacRuleSet);
        IRoleAuthenticator<SubjectInformationType> roleAuthenticator = this.getSimpleRbacRoleAuthenticator();
        ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider = this.getSimpleRbacSubjectInformationProvider();
        return new AuthorizedDefaultServletParams<SubjectInformationType>(new SimpleRbacFilesAuthorizer<SubjectInformationType>((IRbacRuleChecker)rbacRuleChecker, roleAuthenticator), subjectInformationProvider);
    }

    public RbacRuleSet getRbacRuleSet() {
        try {
            Consumer<ObjectMapper> mapperAddIn = mapper -> mapper.registerSubtypes(new NamedType[]{new NamedType(PathTargetInformation.class, "path")});
            return new RbacRuleSetDeserializer(mapperAddIn).fromFile(this.securityConfig.getAuthorizationStrategySimpleRbacRulesFilePath());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private IRoleAuthenticator<SubjectInformationType> getSimpleRbacRoleAuthenticator() {
        return (IRoleAuthenticator)AuthorizationDynamicClassLoader.loadInstanceDynamically((BaSyxConfiguration)this.securityConfig, (String)"authorization.strategy.simpleRbac.roleAuthenticator", IRoleAuthenticator.class);
    }

    private ISubjectInformationProvider<SubjectInformationType> getSimpleRbacSubjectInformationProvider() {
        return (ISubjectInformationProvider)AuthorizationDynamicClassLoader.loadInstanceDynamically((BaSyxConfiguration)this.securityConfig, (String)"authorization.strategy.simpleRbac.subjectInformationProvider", ISubjectInformationProvider.class);
    }
}

