/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Timestamp;
import com.sleepycat.je.utilint.VLSN;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RollbackStart
implements Loggable {
    private VLSN matchpointVLSN;
    private long matchpointLSN;
    private Set<Long> activeTxnIds;
    private Timestamp time;

    public RollbackStart(VLSN matchpointVLSN, long matchpointLSN, Set<Long> activeTxnIds) {
        this.matchpointVLSN = matchpointVLSN;
        this.matchpointLSN = matchpointLSN;
        this.activeTxnIds = activeTxnIds;
        this.time = new Timestamp(System.currentTimeMillis());
    }

    public RollbackStart() {
    }

    public long getMatchpoint() {
        return this.matchpointLSN;
    }

    public Set<Long> getActiveTxnIds() {
        return this.activeTxnIds;
    }

    public VLSN getMatchpointVLSN() {
        return this.matchpointVLSN;
    }

    @Override
    public int getLogSize() {
        int size = LogUtils.getPackedLongLogSize(this.matchpointVLSN.getSequence()) + LogUtils.getPackedLongLogSize(this.matchpointLSN) + LogUtils.getTimestampLogSize(this.time) + LogUtils.getPackedIntLogSize(this.activeTxnIds.size());
        for (Long id : this.activeTxnIds) {
            size += LogUtils.getPackedLongLogSize(id);
        }
        return size;
    }

    @Override
    public void writeToLog(ByteBuffer buffer) {
        LogUtils.writePackedLong(buffer, this.matchpointVLSN.getSequence());
        LogUtils.writePackedLong(buffer, this.matchpointLSN);
        LogUtils.writeTimestamp(buffer, this.time);
        LogUtils.writePackedInt(buffer, this.activeTxnIds.size());
        for (Long id : this.activeTxnIds) {
            LogUtils.writePackedLong(buffer, id);
        }
    }

    @Override
    public void readFromLog(ByteBuffer buffer, int entryVersion) {
        this.matchpointVLSN = new VLSN(LogUtils.readPackedLong(buffer));
        this.matchpointLSN = LogUtils.readPackedLong(buffer);
        this.time = LogUtils.readTimestamp(buffer, false);
        int setSize = LogUtils.readPackedInt(buffer);
        this.activeTxnIds = new HashSet<Long>(setSize);
        for (int i = 0; i < setSize; ++i) {
            this.activeTxnIds.add(LogUtils.readPackedLong(buffer));
        }
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append(" matchpointVLSN=").append(this.matchpointVLSN.getSequence());
        sb.append(" matchpointLSN=");
        sb.append(DbLsn.getNoFormatString(this.matchpointLSN));
        ArrayList<Long> displayTxnIds = new ArrayList<Long>(this.activeTxnIds);
        Collections.sort(displayTxnIds);
        sb.append(" activeTxnIds=").append(displayTxnIds);
        sb.append("\" time=\"").append(this.time);
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof RollbackStart)) {
            return false;
        }
        RollbackStart otherRS = (RollbackStart)other;
        return this.matchpointVLSN.equals(otherRS.matchpointVLSN) && this.matchpointLSN == otherRS.matchpointLSN && this.time.equals(otherRS.time) && this.activeTxnIds.equals(otherRS.activeTxnIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dumpLog(sb, true);
        return sb.toString();
    }
}

