/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.logging.logback.BrokerFileLoggerImpl;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.FixedKeyMapCreator;

final class BrokerFileLoggerImplWithAccessChecking
extends BrokerFileLoggerImpl {
    private static final FixedKeyMapCreator GET_FILE_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"fileName"});
    private static final FixedKeyMapCreator GET_FILES_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"fileName"});

    BrokerFileLoggerImplWithAccessChecking(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    public Map<String, Object> getStatistics(List<String> statistics) {
        return super.getStatistics(statistics);
    }

    public String setContextVariable(final String name, final String value) {
        return (String)this.doSync(this.doOnConfigThread((Task)new Task<ListenableFuture<String>, RuntimeException>(){
            private String _args;

            public ListenableFuture<String> execute() {
                return Futures.immediateFuture((Object)BrokerFileLoggerImplWithAccessChecking.super.setContextVariable(name, value));
            }

            public String getObject() {
                return BrokerFileLoggerImplWithAccessChecking.this.toString();
            }

            public String getAction() {
                return "setContextVariable";
            }

            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name + ",value=" + value;
                }
                return this._args;
            }
        }));
    }

    public String removeContextVariable(final String name) {
        return (String)this.doSync(this.doOnConfigThread((Task)new Task<ListenableFuture<String>, RuntimeException>(){
            private String _args;

            public ListenableFuture<String> execute() {
                return Futures.immediateFuture((Object)BrokerFileLoggerImplWithAccessChecking.super.removeContextVariable(name));
            }

            public String getObject() {
                return BrokerFileLoggerImplWithAccessChecking.this.toString();
            }

            public String getAction() {
                return "removeContextVariable";
            }

            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name;
                }
                return this._args;
            }
        }));
    }

    @Override
    public void resetStatistics() {
        this.authorise(Operation.INVOKE_METHOD((String)"resetStatistics"));
        this.doSync(this.doOnConfigThread((Task)new Task<ListenableFuture<Void>, RuntimeException>(){
            private String _args;

            public ListenableFuture<Void> execute() {
                BrokerFileLoggerImplWithAccessChecking.super.resetStatistics();
                return Futures.immediateFuture(null);
            }

            public String getObject() {
                return BrokerFileLoggerImplWithAccessChecking.this.toString();
            }

            public String getAction() {
                return "resetStatistics";
            }

            public String getArguments() {
                return this._args;
            }
        }));
    }

    @Override
    public Content getFile(String fileName) {
        this.authorise(Operation.INVOKE_METHOD((String)"getFile"), GET_FILE_MAP_CREATOR.createMap(new Object[]{fileName}));
        return super.getFile(fileName);
    }

    @Override
    public Content getFiles(Set<String> fileName) {
        this.authorise(Operation.INVOKE_METHOD((String)"getFiles"), GET_FILES_MAP_CREATOR.createMap(new Object[]{fileName}));
        return super.getFiles(fileName);
    }

    @Override
    public Content getAllFiles() {
        this.authorise(Operation.INVOKE_METHOD((String)"getAllFiles"));
        return super.getAllFiles();
    }
}

