/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.gc;

import jetbrains.exodus.core.execution.LatchJob;
import jetbrains.exodus.gc.GarbageCollector;
import jetbrains.exodus.log.Log;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CleanWholeLogJob
extends LatchJob {
    private static final Logger logger = LoggerFactory.getLogger(CleanWholeLogJob.class);
    @NotNull
    private final GarbageCollector gc;

    CleanWholeLogJob(@NotNull GarbageCollector gc) {
        this.gc = gc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Throwable {
        CleanWholeLogJob.info("CleanWholeLogJob started");
        try {
            long numberOfFiles;
            Log log = this.gc.getLog();
            long lastNumberOfFiles = Long.MAX_VALUE;
            while ((numberOfFiles = log.getNumberOfFiles()) != 1L && numberOfFiles < lastNumberOfFiles) {
                lastNumberOfFiles = numberOfFiles;
                long highFileAddress = log.getHighFileAddress();
                long fileAddress = log.getLowAddress();
                while (fileAddress != highFileAddress) {
                    this.gc.doCleanFile(fileAddress);
                    fileAddress = log.getNextFileAddress(fileAddress);
                }
                this.gc.testDeletePendingFiles();
            }
        }
        finally {
            this.release();
            CleanWholeLogJob.info("CleanWholeLogJob finished");
        }
    }

    private static void info(@NotNull String message) {
        if (logger.isInfoEnabled()) {
            logger.info(message);
        }
    }
}

