/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import java.io.PrintStream;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.tree.Dumpable;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BTreeTraverser;
import jetbrains.exodus.tree.btree.BaseLeafNode;
import jetbrains.exodus.tree.btree.BasePageMutable;
import jetbrains.exodus.tree.btree.ILeafNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BasePage
implements Dumpable {
    @NotNull
    protected final BTreeBase tree;
    protected int size;

    protected BasePage(@NotNull BTreeBase tree) {
        this.tree = tree;
    }

    protected final int getSize() {
        return this.size;
    }

    @NotNull
    protected final BTreeBase getTree() {
        return this.tree;
    }

    @NotNull
    protected BasePage getChild(int index) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    ILeafNode getMinKey() {
        if (this.size <= 0) {
            throw new ArrayIndexOutOfBoundsException("Page is empty.");
        }
        return this.getKey(0);
    }

    @NotNull
    ILeafNode getMaxKey() {
        if (this.size <= 0) {
            throw new ArrayIndexOutOfBoundsException("Page is empty.");
        }
        return this.getKey(this.size - 1);
    }

    boolean isInPageRange(@NotNull ByteIterable key, @Nullable ByteIterable value) {
        ByteIterable maxValue;
        ILeafNode maxKey = this.getMaxKey();
        int cmp = maxKey.getKey().compareTo((Object)key);
        if (cmp < 0) {
            return false;
        }
        if (cmp == 0 && value != null && ((maxValue = maxKey.getValue()) == null || maxValue.compareTo((Object)value) < 0)) {
            return false;
        }
        if (this.size == 1) {
            return true;
        }
        ILeafNode minKey = this.getMinKey();
        cmp = minKey.getKey().compareTo((Object)key);
        if (cmp > 0) {
            return false;
        }
        if (cmp == 0 && value != null) {
            ByteIterable minValue = minKey.getValue();
            return minValue != null && minValue.compareTo((Object)value) <= 0;
        }
        return true;
    }

    protected boolean isDupKey(int index) {
        return this.getKey(index).isDup();
    }

    @NotNull
    protected abstract BaseLeafNode getKey(int var1);

    @NotNull
    protected abstract BasePageMutable getMutableCopy(BTreeMutable var1);

    protected abstract long getDataAddress();

    protected abstract long getKeyAddress(int var1);

    protected abstract boolean isBottom();

    protected abstract boolean isMutable();

    protected abstract long getBottomPagesCount();

    protected abstract int binarySearch(ByteIterable var1);

    protected abstract int binarySearch(ByteIterable var1, int var2);

    @Nullable
    protected abstract ILeafNode get(@NotNull ByteIterable var1);

    @Nullable
    protected abstract ILeafNode find(@NotNull BTreeTraverser var1, int var2, @NotNull ByteIterable var3, @Nullable ByteIterable var4, boolean var5);

    protected abstract boolean keyExists(@NotNull ByteIterable var1);

    protected abstract boolean exists(@NotNull ByteIterable var1, @NotNull ByteIterable var2);

    protected abstract boolean childExists(@NotNull ByteIterable var1, long var2);

    protected abstract long getChildAddress(int var1);

    static void indent(PrintStream out, int level) {
        for (int i = 0; i < level; ++i) {
            out.print(" ");
        }
    }
}

