/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.protocol.v0_10.transport.Decoder;
import org.apache.qpid.server.protocol.v0_10.transport.Encoder;
import org.apache.qpid.server.protocol.v0_10.transport.MessageAcceptMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageAcquireMode;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.MethodDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.Option;

public final class MessageSubscribe
extends Method {
    public static final int TYPE = 1031;
    private short packing_flags = 0;
    private String queue;
    private String destination;
    private MessageAcceptMode acceptMode;
    private MessageAcquireMode acquireMode;
    private String resumeId;
    private long resumeTtl;
    private Map<String, Object> arguments;

    @Override
    public final int getStructType() {
        return 1031;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public MessageSubscribe() {
    }

    public MessageSubscribe(String queue, String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, String resumeId, long resumeTtl, Map<String, Object> arguments, Option ... _options) {
        if (queue != null) {
            this.setQueue(queue);
        }
        if (destination != null) {
            this.setDestination(destination);
        }
        if (acceptMode != null) {
            this.setAcceptMode(acceptMode);
        }
        if (acquireMode != null) {
            this.setAcquireMode(acquireMode);
        }
        if (resumeId != null) {
            this.setResumeId(resumeId);
        }
        this.setResumeTtl(resumeTtl);
        if (arguments != null) {
            this.setArguments(arguments);
        }
        block7: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case EXCLUSIVE: {
                    this.packing_flags = (short)(this.packing_flags | 0x1000);
                    continue block7;
                }
                case SYNC: {
                    this.setSync(true);
                    continue block7;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block7;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block7;
                }
                case NONE: {
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + _options[i]);
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.messageSubscribe(context, this);
    }

    public final boolean hasQueue() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final MessageSubscribe clearQueue() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.queue = null;
        this.setDirty(true);
        return this;
    }

    public final String getQueue() {
        return this.queue;
    }

    public final MessageSubscribe setQueue(String value) {
        this.queue = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final MessageSubscribe queue(String value) {
        return this.setQueue(value);
    }

    public final boolean hasDestination() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final MessageSubscribe clearDestination() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.destination = null;
        this.setDirty(true);
        return this;
    }

    public final String getDestination() {
        return this.destination;
    }

    public final MessageSubscribe setDestination(String value) {
        this.destination = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.setDirty(true);
        return this;
    }

    public final MessageSubscribe destination(String value) {
        return this.setDestination(value);
    }

    public final boolean hasAcceptMode() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final MessageSubscribe clearAcceptMode() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.acceptMode = null;
        this.setDirty(true);
        return this;
    }

    public final MessageAcceptMode getAcceptMode() {
        return this.acceptMode;
    }

    public final MessageSubscribe setAcceptMode(MessageAcceptMode value) {
        this.acceptMode = value;
        this.packing_flags = (short)(this.packing_flags | 0x400);
        this.setDirty(true);
        return this;
    }

    public final MessageSubscribe acceptMode(MessageAcceptMode value) {
        return this.setAcceptMode(value);
    }

    public final boolean hasAcquireMode() {
        return (this.packing_flags & 0x800) != 0;
    }

    public final MessageSubscribe clearAcquireMode() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFF7FF);
        this.acquireMode = null;
        this.setDirty(true);
        return this;
    }

    public final MessageAcquireMode getAcquireMode() {
        return this.acquireMode;
    }

    public final MessageSubscribe setAcquireMode(MessageAcquireMode value) {
        this.acquireMode = value;
        this.packing_flags = (short)(this.packing_flags | 0x800);
        this.setDirty(true);
        return this;
    }

    public final MessageSubscribe acquireMode(MessageAcquireMode value) {
        return this.setAcquireMode(value);
    }

    public final boolean hasExclusive() {
        return (this.packing_flags & 0x1000) != 0;
    }

    public final MessageSubscribe clearExclusive() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFEFFF);
        this.setDirty(true);
        return this;
    }

    public final boolean getExclusive() {
        return this.hasExclusive();
    }

    public final MessageSubscribe setExclusive(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x1000) : (short)(this.packing_flags & 0xFFFFEFFF);
        this.setDirty(true);
        return this;
    }

    public final MessageSubscribe exclusive(boolean value) {
        return this.setExclusive(value);
    }

    public final boolean hasResumeId() {
        return (this.packing_flags & 0x2000) != 0;
    }

    public final MessageSubscribe clearResumeId() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFDFFF);
        this.resumeId = null;
        this.setDirty(true);
        return this;
    }

    public final String getResumeId() {
        return this.resumeId;
    }

    public final MessageSubscribe setResumeId(String value) {
        this.resumeId = value;
        this.packing_flags = (short)(this.packing_flags | 0x2000);
        this.setDirty(true);
        return this;
    }

    public final MessageSubscribe resumeId(String value) {
        return this.setResumeId(value);
    }

    public final boolean hasResumeTtl() {
        return (this.packing_flags & 0x4000) != 0;
    }

    public final MessageSubscribe clearResumeTtl() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFBFFF);
        this.resumeTtl = 0L;
        this.setDirty(true);
        return this;
    }

    public final long getResumeTtl() {
        return this.resumeTtl;
    }

    public final MessageSubscribe setResumeTtl(long value) {
        this.resumeTtl = value;
        this.packing_flags = (short)(this.packing_flags | 0x4000);
        this.setDirty(true);
        return this;
    }

    public final MessageSubscribe resumeTtl(long value) {
        return this.setResumeTtl(value);
    }

    public final boolean hasArguments() {
        return (this.packing_flags & 0x8000) != 0;
    }

    public final MessageSubscribe clearArguments() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFF7FFF);
        this.arguments = null;
        this.setDirty(true);
        return this;
    }

    public final Map<String, Object> getArguments() {
        return this.arguments;
    }

    public final MessageSubscribe setArguments(Map<String, Object> value) {
        this.arguments = value;
        this.packing_flags = (short)(this.packing_flags | 0x8000);
        this.setDirty(true);
        return this;
    }

    public final MessageSubscribe arguments(Map<String, Object> value) {
        return this.setArguments(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStr8(this.queue);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeStr8(this.destination);
        }
        if ((this.packing_flags & 0x400) != 0) {
            enc.writeUint8(this.acceptMode.getValue());
        }
        if ((this.packing_flags & 0x800) != 0) {
            enc.writeUint8(this.acquireMode.getValue());
        }
        if ((this.packing_flags & 0x2000) != 0) {
            enc.writeStr16(this.resumeId);
        }
        if ((this.packing_flags & 0x4000) != 0) {
            enc.writeUint64(this.resumeTtl);
        }
        if ((this.packing_flags & 0x8000) != 0) {
            enc.writeMap(this.arguments);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.queue = dec.readStr8();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.destination = dec.readStr8();
        }
        if ((this.packing_flags & 0x400) != 0) {
            this.acceptMode = MessageAcceptMode.get(dec.readUint8());
        }
        if ((this.packing_flags & 0x800) != 0) {
            this.acquireMode = MessageAcquireMode.get(dec.readUint8());
        }
        if ((this.packing_flags & 0x2000) != 0) {
            this.resumeId = dec.readStr16();
        }
        if ((this.packing_flags & 0x4000) != 0) {
            this.resumeTtl = dec.readUint64();
        }
        if ((this.packing_flags & 0x8000) != 0) {
            this.arguments = dec.readMap();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("queue", this.getQueue());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("destination", this.getDestination());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("acceptMode", (Object)this.getAcceptMode());
        }
        if ((this.packing_flags & 0x800) != 0) {
            result.put("acquireMode", (Object)this.getAcquireMode());
        }
        if ((this.packing_flags & 0x1000) != 0) {
            result.put("exclusive", this.getExclusive());
        }
        if ((this.packing_flags & 0x2000) != 0) {
            result.put("resumeId", this.getResumeId());
        }
        if ((this.packing_flags & 0x4000) != 0) {
            result.put("resumeTtl", this.getResumeTtl());
        }
        if ((this.packing_flags & 0x8000) != 0) {
            result.put("arguments", this.getArguments());
        }
        return result;
    }
}

