/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.logging.messages.AccessControlMessages;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RuleOutcome {
    ALLOW(Result.ALLOWED),
    ALLOW_LOG(Result.ALLOWED){

        @Override
        public Result logResult(EventLoggerProvider logger, LegacyOperation operation, ObjectType objectType, ObjectProperties objectProperties) {
            LOGGER.debug(RuleOutcome.ACTION_MATCHES_RESULT, (Object)this);
            logger.getEventLogger().message(AccessControlMessages.ALLOWED((String)operation.toString(), (String)objectType.toString(), (String)objectProperties.toString()));
            return this._result;
        }
    }
    ,
    DENY(Result.DENIED),
    DENY_LOG(Result.DENIED){

        @Override
        public Result logResult(EventLoggerProvider logger, LegacyOperation operation, ObjectType objectType, ObjectProperties objectProperties) {
            LOGGER.debug(RuleOutcome.ACTION_MATCHES_RESULT, (Object)this);
            logger.getEventLogger().message(AccessControlMessages.DENIED((String)operation.toString(), (String)objectType.toString(), (String)objectProperties.toString()));
            return this._result;
        }
    };

    private static final Logger LOGGER;
    private static final String ACTION_MATCHES_RESULT = "Action matches. Result: {}";
    final Result _result;

    private RuleOutcome(Result result) {
        this._result = result;
    }

    public Result logResult(EventLoggerProvider logger, LegacyOperation operation, ObjectType objectType, ObjectProperties objectProperties) {
        LOGGER.debug(ACTION_MATCHES_RESULT, (Object)this);
        return this._result;
    }

    static {
        LOGGER = LoggerFactory.getLogger(RuleOutcome.class);
    }
}

